const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("businesschance", {
    app_id:DataTypes.INTEGER,
    publisherId:DataTypes.INTEGER,//发布者id
    publisherName:DataTypes.STRING,//发布者姓名
    publisherMobile:DataTypes.STRING,//发布者手机号
    publisherOnlyCode:DataTypes.STRING(50),//发布者唯一码
    publishContent:DataTypes.STRING,//发布内容
    followManId:DataTypes.INTEGER,//跟进人id（合伙人）
    followManName:DataTypes.STRING,//跟进人姓名（合伙人）
    followManMobile:DataTypes.STRING,//跟进人手机号（合伙人）
    followManOnlyCode:DataTypes.STRING(50),//跟进者唯一码
    followContent:DataTypes.STRING,//跟进内容
    shopOnlyCode:DataTypes.STRING(50),//店铺唯一码
    shopName:DataTypes.STRING(50),//店铺名称
    shopNum:DataTypes.BIGINT,//店铺号
    shopMobile:DataTypes.STRING(20),//店铺手机号
    chanceEvaluation:{
      //评论类型："0":"差评","5":"一般","10":"好评"
      type:DataTypes.ENUM,
      defaultValue:"10",
      values: Object.keys(uiconfig.config.pdict.service_evaluation),
      set:function(val){
        this.setDataValue("chanceEvaluation",val);
      }
    },
    followTime:DataTypes.DATE,//跟进时间
    chanceTypeName:DataTypes.STRING,
    chanceType:{
      //商机类型："ip": "商标", "ic": "版权", "pa": "专利", "common": "增值", "icbc": "工商" “iso":"海外服务”
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.chanceType),
      set:function(val){
        this.setDataValue("chanceType",val);
        this.setDataValue("chanceTypeName",uiconfig.config.pdict.chanceType[val]);
      }
    },
    name:DataTypes.STRING,//暂时没有用
    chanceStatusName:DataTypes.STRING,
    chanceStatus:{
      // 商机："1":"待服务","2":"跟进中","4":"成功","8":"失败"
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.chance_status),
      set:function(val){
        this.setDataValue("chanceStatus",val);
        this.setDataValue("chanceStatusName",uiconfig.config.pdict.chance_status[val]);
      }
    },
    baoPrice:{//宝币价格
      type:DataTypes.INTEGER,
      defaultValue:0.00,
    },
    platformChanceType:{
      //平台商机类型:"common":"普通"
      type:DataTypes.ENUM,
      defaultValue:"common",
      values: Object.keys(uiconfig.config.pdict.platform_chance_type),
      set:function(val){
        this.setDataValue("platformChanceType",val);
      }
    },
    notes:DataTypes.STRING,//备注
    //------------------------------------------渠道相关
    channelCode:{
      //渠道编码：p_channel表中的channelCode
      type:DataTypes.STRING(20),
      defaultValue:"hhr",
    },
    serviceItem_code:DataTypes.STRING(20),
    serviceItem_name:DataTypes.STRING,
    orderNum:DataTypes.STRING(50),//自己订单号，目前与订单表无关
    channelUserName:DataTypes.STRING(50),//渠道用户名
    channelOrderNum:DataTypes.STRING(50),//渠道方订单号
    totalSum:DataTypes.DECIMAL(12,2),//总额
    channelProfitRatio:{
      type:DataTypes.DECIMAL(12,2),//渠道分成比率（如：总额100，字段值30，则渠道的利润为30/100，剩下的则为平台利润）
      defaultValue:0.00,
    },
    channelProfit:DataTypes.DECIMAL(12,2),//渠道利润
    platformProfit:DataTypes.DECIMAL(12,2),//平台利润
    disposeNotes:DataTypes.STRING,//处理的备注
    profitTypeName:DataTypes.STRING(50),//渠道利润类型名称
    profitType:{
      //渠道利润类型:1: "比例分成", 2: "每单分成"
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.channelProfitType),
      defaultValue: "1",
      set:function(val){
        this.setDataValue("profitType",val);
        this.setDataValue("profitTypeName",uiconfig.config.pdict.channelProfitType[val]);
      },
    },
    isAllocationName:{
      // 是否分配名称
      type:DataTypes.STRING,
      defaultValue:"否",
    },
    isAllocation:{
      //是否分配："0": "否", "1": "是"
      type:DataTypes.ENUM,
      defaultValue:"0",
      values: Object.keys(uiconfig.config.pdict.isRecommend),
      set:function(val){
        this.setDataValue("isAllocation",val);
        this.setDataValue("isAllocationName",uiconfig.config.pdict.isRecommend[val]);
      },
      defaultValue:"0",
    },
    allocationTime:DataTypes.DATE,//分配时间
    city:DataTypes.STRING(50), // 城市
    province:DataTypes.STRING(50), // 省份
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'h_business_chance',
     validate: {

     },
     indexes:[

     ]
  });
}
