const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);

module.exports = (db, DataTypes) => {
  return db.define("businessallot", {
      // channelmanageallot_'渠道管理者id', 自动生成
      // businesschance_id '商机id', 自动生成
      // user_id  '用户id', 自动生成
      app_id:DataTypes.INTEGER, // 用户应用id
      onlyCode:DataTypes.STRING(50), // 用户唯一码
      notifyCount:DataTypes.INTEGER,  // 通知次数
      status:{
        // 状态: "1":"待接单","2":"已接单","4":"拒接","8":"成功","16":"失败"
        type:DataTypes.ENUM,
        values: Object.keys(uiconfig.config.pdict.businessallowstatus),
        set:function(val){
          this.setDataValue("status",val);
          this.setDataValue("statusName",uiconfig.config.pdict.businessallowstatus[val]);
        }
      },
      statusName:DataTypes.STRING(50),
      notes:DataTypes.STRING(255), //处理备注
      mobile:DataTypes.STRING(20), //接单人手机
      chanceType:{
        //商机类型: "ip": "商标", "ic": "版权", "pa": "专利", "common": "增值", "icbc": "工商" “iso":"海外服务”
        type:DataTypes.ENUM,
        values: Object.keys(uiconfig.config.pdict.chanceType),
        set:function(val){
          this.setDataValue("chanceType",val);
          this.setDataValue("chanceTypeName",uiconfig.config.pdict.chanceType[val]);
        }
      },
      channelCode:DataTypes.STRING(50),       // 渠道码
      chanceTypeName:DataTypes.STRING(50),    // 商机类型名称
      serviceItem_code:DataTypes.STRING(50), // 服务编码
      serviceItem_name:DataTypes.STRING(255), // 服务名称
      publisherName:DataTypes.STRING(255), // 发布者姓名
      publisherMobile:DataTypes.STRING(50), // 发布者电话
      publisherNotes:DataTypes.STRING(255), // 发布者备注
      city:DataTypes.STRING(50), // 城市
      province:DataTypes.STRING(50), // 省份
      accept_at:DataTypes.DATE,
  },{
   paranoid: true,//假的删除
   underscored: true,
   version: true,
   freezeTableName: true,
   //freezeTableName: true,
   // define the table's name
   tableName: 'c_business_allot',
   validate: {

   },
   indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
