const system=require("../../system");
const settings=require("../../../config/settings");
module.exports = (db, DataTypes) => {
  return db.define("apibalance", {
    op:{//访问路径
      type:DataTypes.STRING,
      allowNull: true,
    },
    params:{
      type:DataTypes.STRING(1024),
      allowNull: true,
    },
    clientIp:DataTypes.STRING,
    agent:{
      type:DataTypes.STRING,
      allowNull: true,
    },
    isAllowed:{
      type:DataTypes.BOOLEAN,
      defaultValue: true
    },
    price: {//每条多少钱
      type:DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    desc:DataTypes.STRING,//比如前500条免费
  },{
     paranoid: false,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     timestamps: true,
     updatedAt:false,
     //freezeTableName: true,
     // define the table's name
     tableName: 'api_apibalance',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
