const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("accountlog", {
    accountId: DataTypes.INTEGER,
    accountUnionId: DataTypes.STRING,
    beforeBaoBalance:{
      type:DataTypes.DECIMAL(12,2),
      defaultValue:0.00,
    },
    beforeRenBalance:{
      type:DataTypes.DECIMAL(12,2),
      defaultValue:0.00,
    },
    afterBaoBalance:{
      type:DataTypes.DECIMAL(12,2),
      defaultValue:0.00,
    },
    afterRenBalance:{
      type:DataTypes.DECIMAL(12,2),
      defaultValue:0.00,
    },
    logTypeName:DataTypes.STRING,
    logType:{
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.account_log_type),
      set:function(val){
        this.setDataValue("logType",val);
        this.setDataValue("logTypeName",uiconfig.config.pdict.account_log_type[val]);
      }
    }
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'p_account_log',
     validate: {

     },
     indexes:[

     ]
  });
}
