const system = require("../../system");
const Dao = require("../dao.base");
class WorkcrSubmitDao extends Dao {
  constructor() {
    super(Dao.getModelName(WorkcrSubmitDao));
  }
  //添加作品著作权数据
  async createOrder2ToAddWorks(tmpProxyCode, copyright, order,apply, t) {
    //作者姓名或名称以及作品署名 
    var tmpAuthorData = [];
    tmpAuthorData.push({
      "authorName": apply.authorName,
      "authorSign": apply.authorSign
    });
    var addParam = {
      orderCreateOnlyCode: order.onlyCode,
      orderCreateAppId: order.app_id,
      orderNum: order.orderNum,
      // sourceTypeName: order.sourceTypeName,
      sourceType: order.orderSourceType,//'订单来源类型，1PC，2移动商城，4渠道方，默认为2',
      // sourceNotes          varchar(255) comment '订单来源备注',
      channelCode: order.channelCode,
      channelName: order.channelName,
      // relevanceStatusName  varchar(50) comment '关联状态名称',
      // relevanceStatus      enum('1','2') comment '关联状态，1未关联订单，2，已关联订单',
      // statusProgressName   varchar(50) comment '进展状态名称',
      statusProgress: "COMMITED", //AWAITCHECK等待审核、WAITARTIFICIALEXAMINE等待人工审核、COMMITED人工已提交、READY资料准备
      orderNotes: order.remark,
      // opAppId              int comment '操作者平台应用id',
      // opUserId             int default 0 comment '操作用户id',
      // opUserName           varchar(50) comment '操作平台用户名',
      // opOnlyCode           varchar(50) comment '操作者唯一码',
      // opNotes              varchar(255) comment '操作备注',
      name: copyright.name,//名称
      //compositionTypeName  varchar(50) comment '作品著作权分类名称',
      compositionType: copyright.compositionType,//作品著作权分类（wz文字、ks口述、yl音乐、xj戏剧、qy曲艺 、wd舞蹈 、zjys杂技艺术、ms美术 、jz建筑 、sy摄影 、dy电影和类似摄制电影方法创作的作品、tx图形、mj模型、qt其他 ）',
      compositionTypeDesc: copyright.compositionTypeDesc,//作品著作权分类说明',
      authorData: JSON.stringify(tmpAuthorData),//作者姓名或名称以及作品署名：[{"authorName":"作者","authorSign":"作者署名"}]',
      // opusInditeKindName   varchar(50) comment '作品创作性质名称',
      opusInditeKind: "yc",//copyright.opusInditeKind,//作品创作性质：yc:原创,gb:改编,fy:翻译,hb:汇编,zs:注释,zl:整理,qt:其他',
      opusDesc: copyright.opusDesc,//作品创作性质说明',
      opusCreateDate: copyright.opusCreateDate,//作品创作完成日期',
      finishCountry: copyright.finishCountry,//完成国家',
      finishCity: copyright.finishCity,//完成城市',
      // publishStatusName    varchar(50) comment '发表状态名称',
      publishStatus: "1",//发表状态1已发表，2未发表',
      appearDate: copyright.appearDate || null,//首次发表日期',
      appearCountry: copyright.appearCountry || "",//首次发表地点国家',
      appearCity: copyright.appearCity || "",//首次发表地点城市',
      // obtainModeName       varchar(50) comment '权利取得方式名称',
      obtainMode: "ys",//权利取得方式：ys:原始,jc:继承,cs:承受,qt:其他',
      inheritDesc: copyright.inheritDesc,//权利取得方式为原始以外的有此值：权利取得方式说明',
      // rightOwnModeName     varchar(50) comment '权利归属方式名称',
      rightOwnMode: "grzp",//copyright.rightOwnMode,//权利归属方式：grzp:个人作品,hzzp:合作作品,frzp:法人作品,zwzp:职务作品,wtzp:委托作品',
      rightOwnDesc: copyright.rightOwnDesc,//权利归属方式说明',
      // rightScopeName       varchar(50) comment '权利拥有状况名称',
      rightScope: "1",//权利拥有状况1全部，2部分',
      rightScopeList: "",//权利拥有状况为部分有此值，部分选项集合',
      ownPartDesc: copyright.ownPartDesc,//权利拥有状况说明',
      emedium: copyright.emedium, //电子介质',
      ecount: copyright.ecount, //电子介质几件',
      pmedium: copyright.pmedium,//纸介质',
      pcount: copyright.pcount,//纸介质几张',
      // applyTypeName        varchar(50) comment '申请办理方式名称',
      applyType: "2",//            enum('1','2') comment '申请办理方式1由著作权任申请，2由代理任申请',
      proxyCode:tmpProxyCode,
      declarationUrl:apply.declarationUrl,//法人作品声明Url
      authorizationUrl:apply.authorizationUrl,//作品授权书Url
      descUrl:apply.descUrl,//作品说明Url
      workPicUrl:apply.workPicUrl//作品Url
    };
    await this.create(addParam, t);
  }
}
module.exports = WorkcrSubmitDao;
