const system = require("../../system");
const Dao = require("../dao.base");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
const tmSourceTypeToChannelCode = uiconfig.config.pdict.tmSourceTypeToChannelCode;//商标来源对应渠道码
const channelCodeToTmSourceType = uiconfig.config.pdict.channelCodeToTmSourceType;//渠道码对应商标来源
class TrademarkDao extends Dao {
  constructor() {
    super(Dao.getModelName(TrademarkDao));
  }
  judgeChannelCode(channelcode) {//判断渠道编码是否为igirl-channel渠道，若是返回渠道码对应商标来源类型
    if (!channelCodeToTmSourceType || !channelcode) {
      return null;
    }
    if (channelCodeToTmSourceType.hasOwnProperty(channelcode)) {
      return channelCodeToTmSourceType[channelcode];
    } else {
      return null;
    }
  }
  judgeTmSourceType(type) {//判断商标来源类型是否为igirl-channel来源，若是返回来源类型对应渠道码
    if (!tmSourceTypeToChannelCode || !type) {
      return null;
    }
    if (tmSourceTypeToChannelCode.hasOwnProperty(type)) {
      return tmSourceTypeToChannelCode[type];
    } else {
      return null;
    }
  }
  orderBy() {
    //return {"key":"include","value":{model:this.db.models.app}};
    return [["lastUp", "DESC"]];
  }
  extraWhere(obj, w) {
    if (obj.codepath && obj.codepath != "") {
      if (obj.codepath.indexOf("alltrademark") < 0 && obj.codepath.indexOf("allfqtm") < 0) {
        //  改成当前登录者的onlyCode进行查不同平台的用户提报的商标数据
        var whereArray = [];
        if (obj.onlyCode) {
          whereArray.push({ [this.db.Op.and]: [{ onlyCode: obj.onlyCode }] });
        }
        if (obj.mobile) {
          whereArray.push({ [this.db.Op.and]: [{ mobile: obj.mobile }] });
        }
        if (obj.uid) {
          whereArray.push({ [this.db.Op.and]: [{ user_id: obj.uid }] });
        }
        w[this.db.Op.or] = whereArray;
      }
      else {
        //----平台的运营人员可以看全部的商标信息 
        var whereArray = [];
        whereArray.push({ [this.db.Op.and]: [{ channelPayStatus: "yzf" }] });
        whereArray.push({ [this.db.Op.and]: [{ channelPayStatus: "wzf" },{ tmSourceType: "32" }] });
        w[this.db.Op.or] = whereArray;
        //----平台的运营人员可以看全部的商标信息
        // w["channelPayStatus"] = "yzf";
      }
    }
    return w;
  }
  async getTmByOrderNumStatus(orderNum, tmStatus) {
    //根据订单号及状态查询商标
    var qc = {
      'where': { 'orderNum': orderNum, 'tmStatus': tmStatus }
    };
    var apps = await this.model.findAndCountAll(qc);
    return apps;
  }
  async getTmByOrderNum(orderNum) {
    var qc = {
      'where': { 'orderNum': orderNum }
    };
    var apps = await this.model.findAndCountAll(qc);
    return apps;
  }
  async getTmsByCalcId(calcId) {
    var qc = {
      'where': { 'nclCalc_id': calcId }
    };
    var apps = await this.model.findAndCountAll(qc);
    return apps;
  }
  async deleteByOrderNum(orderNum, t) {
    var en = await this.model.destroy({ where: { orderNum: orderNum } }, { transaction: t });
    return en;
  }
}
module.exports = TrademarkDao;
