const system = require("../../system");
const Dao = require("../dao.base");
class TmcustomerinfoDao extends Dao {
  constructor() {
    super(Dao.getModelName(TmcustomerinfoDao));
  }
  extraWhere(obj, w) {

    if (obj.codepath && obj.codepath != "") {
      if (obj.codepath.indexOf("calculateprice") > 0) {
        w["user_id"] = obj.uid;
      }
    }
    return w;
  }
  // extraModelFilter(){
  //   return {"key":"include","value":[{model:this.db.models.calculateprice}]};
  // }
  async findOneByOrderNum(orderNum) {
    var app = await this.model.findOne({ where: { orderNum: orderNum } });
    return app;
  }
  async findItemByOrderNum(orderNum) {
    var app = await this.model.findOne({
      where: { orderNum: orderNum }
      , attributes: ["id", "customerContact", "mobile", "email"]
      , raw: true
    });
    return app;
  }
}
module.exports = TmcustomerinfoDao;
