const system = require("../../system");
const Dao = require("../dao.base");
class TmapplierinfoDao extends Dao {
  constructor() {
    super(Dao.getModelName(TmapplierinfoDao));
  }

  async getApplierInfoByOrderNum(orderNum) {
    var qc = {
      'where': { 'orderNum': orderNum }
    };
    var apps = await this.model.findAndCountAll(qc);
    return apps;
  }
  async findOneByOrderNum(orderNum) {
    var app = await this.model.findOne({ where: { orderNum: orderNum } });
    return app;
  }
  async findItemByOrderNum(orderNum) {
    var app = await this.model.findOne({
      where: { orderNum: orderNum }
      , attributes: ["id", "type", "identityCardPic", "businessLicensePic"]
      , raw: true
    });
    return app;
  }
  async findByName(applierName) {
    var qc = {
      'where': { 'applyName': { [this.db.Op.like]: "%" + applierName + "%" } }
    };
    var apps = await this.model.findAndCountAll(qc);
    return apps;
  }
}
module.exports = TmapplierinfoDao;
