const system=require("../../system");
const Dao=require("../dao.base");
class ServicesitemDao extends Dao{
  constructor(){
    super(Dao.getModelName(ServicesitemDao));
  }
  async findService5(queryobj,qobj){
    return this.model.findAll({
      limit:5,
      offset:0,
    });
  }
  async findOneByCode(code){
    return this.model.findOne({"where":{"code":code}});
  }
  orderBy(){
    //return {"key":"include","value":{model:this.db.models.app}};
    return [["sort","asc"],["created_at","DESC"]];
  }
  async findAndCountAll(qobj,t){
    var list=await super.findAndCountAll(qobj,t);
    return list;
  }
  extraModelFilter(){
    //return {"key":"include","value":[{model:this.db.models.app,},{model:this.db.models.role,as:"Roles",attributes:["id","name"],joinTableAttributes:['created_at']}]};
    return {"key":"include","value":[{model:this.db.models.channel,attributes:["id","channelName",]}]};
  }
  extraWhere(obj,w){
     if(obj.codepath && obj.codepath!=""){
       if(obj.codepath.indexOf("tmstock")>=0){  //商标库管理====IE标
          w["channelCode"]="yzc";
       }
     }
     return w;
  }

}
module.exports=ServicesitemDao;
