const system=require("../../system");
const Dao=require("../dao.base");
class ProductDao extends Dao{
  constructor(){
    super(Dao.getModelName(ProductDao));
    this.appDao=system.getObject("db.appDao");
  }
  async list(appidkey){
    return this.model.findAll({
      where:{isPubed:true},
      include:{
        model:this.appDao.model,
        where:{appid:appidkey}
      },
      order:this.orderBy(),
    });
  }
  orderBy(){
    //return {"key":"include","value":{model:this.db.models.app}};
    return [["orderNo","ASC"]];
  }
  async findOneByCode(code){
    var product = await this.model.findOne({where:{code:code}})
    return product;
  }
}
module.exports=ProductDao;
