const system=require("../../system");
const Dao=require("../dao.base");
class PatentinfoDao extends Dao{
  constructor(){
    super(Dao.getModelName(PatentinfoDao));
  }
  extraWhere(obj,w){
     if(obj.codepath && obj.codepath!=""){
       if(obj.codepath.indexOf("patentarch")>0){
          w["user_id"]=obj.uid;
       }
     }
     if(obj.codepath.indexOf("patentfreesubmit")>=0){
        w["user_id"]=obj.uid;
     }
     return w;
  }

  async findByIds(ids){
    var qc={
        'where': { 'id': {[this.db.Op.in]: ids}}
    };
    var apps=  await this.model.findAndCountAll(qc);
    return apps;
  }
  async findByCodes(codes){
    var qc={
        'where': { 'code': {[this.db.Op.in]: codes}}
    };
    var apps=  await this.model.findAndCountAll(qc);
    return apps;
  }
  async findOneByCode(code){
    return this.model.findOne({"where":{"code":code}});
  }
  async findByOrderNum(orderNum){
    var qc={
        'where': { 'orderNum': orderNum}
    };
    var apps= await this.model.findAndCountAll(qc);
    return apps;
  }
}
module.exports=PatentinfoDao;
