const system=require("../../system");
const Dao=require("../dao.base");
class PageStatisticsDao extends Dao{
  constructor(){
    super(Dao.getModelName(PageStatisticsDao));
  }
  //获取某个用户统计编码的所有信息
  async getUserAllStatistics(onlycode,item_code_list,statistics_code){
    return this.model.findAll({where:{onlyCode:onlycode,itemCode:{[this.db.Op.in]:item_code_list},statisticsCode:statistics_code},
                                                   attributes:["id","itemCode"],
                                                   raw:true});
  }
  //获取某个用户统计编码的次数
  async getUserAllStatisticsCount(item_code,statistics_code){
    return this.findCount({where:{itemCode:item_code,statisticsCode:statistics_code}});
  }
  async getUserTotalList(item_code_list,statistics_code_list){
    var item_codeStr=item_code_list.join(',');
    var statistics_codeStr=statistics_code_list.join(',');
    item_codeStr="'"+item_codeStr.replace(',',"','")+"'";
    statistics_codeStr="'"+statistics_codeStr.replace(',',"','")+"'";
    var sql="select statisticsCode,itemCode,count(distinct(onlyCode)) as totalCount from `h_page_statistics` where itemCode in("+item_codeStr+")"+
            " and statisticsCode in("+statistics_codeStr+") group by itemCode,statisticsCode"
     return this.customQuery(sql,null);
  }
}
module.exports=PageStatisticsDao;
