const system=require("../../system");
const Dao=require("../dao.base");
class OrderflowDao extends Dao{
  constructor(){
    super(Dao.getModelName(OrderflowDao));
  }
  extraWhere(obj,w){
     if(obj.codepath && obj.codepath!=""){
       if(obj.codepath.indexOf("calculateprice")>0){
          w["user_id"]=obj.uid;
       }
     }
     return w;
  }
  extraModelFilter(){
    return {"key":"include","value":[{model:this.db.models.tmcustomerinfo}]};
  }
  async findByOrder(orderNum){
    var app=  await this.model.findAndCountAll({where:{orderNum:orderNum,logType:"orderlog"}});
    return app;
  }
  async findByTm(tmProxyCode){
    var app=  await this.model.findAndCountAll({where:{tmProxyCode:tmProxyCode,logType:"tmlog"}});
    return app;
  }
}
module.exports=OrderflowDao;
