const system=require("../../system");
const Dao=require("../dao.base");
class EcontractDao extends Dao{
  constructor(){
    super(Dao.getModelName(EcontractDao));
  }

  extraModelFilter() {
    let v = [
              {model:this.db.models.ecompany,attributes:["id","name"]},
              {model:this.db.models.user,attributes:["id","userName","mobile","personsSign"]},
              {model:this.db.models.etemplate,attributes:["id","name"]}
            ];
    //return {"key":"include","value":[{model:this.db.models.app,},{model:this.db.models.role,as:"Roles",attributes:["id","name"],joinTableAttributes:['created_at']}]};
    return {"key":"include","value": v};
  }

  async findUserSinedCompanyIds(usereaccount_id) {
    let sql = "SELECT ecompany_id FROM `c_econtract` WHERE usereaccount_id = :usereaccount_id AND begin_at < NOW() AND end_at > NOW() AND eflowstatus = '2' GROUP BY ecompany_id";

    let tmpParas = {usereaccount_id : usereaccount_id}

    let rs = await this.customQuery(sql, tmpParas);
    let list = [];
    if(rs && rs.length > 0) {
      for(let r of rs) {
        list.push(r.ecompany_id);
      }
    }
    return list;
  }
}
module.exports=EcontractDao;
