const system=require("../../system");
const settings = require("../../../config/settings");
class ChannelReceiveDao {
  constructor(){
    this.channelApiUrl = settings.channelApiUrl();
    this.oplogSve = system.getObject("service.oplogSve");
  }
  //推送渠道商标状态修改信息(同步商标注册号|商标状态|推送商标回执)
  async updateChannelTmStatus(obj) {
    try {
      var channelApiUrl = this.channelApiUrl;
      channelApiUrl = settings.channelApiUrl("gsbh5");
      var reqUrl = channelApiUrl + "/notifyaction/internalCallsNotify/updateTmStatus";
      var rc = system.getObject("util.execClient");
      var rtn = await rc.execPost(obj, reqUrl);
      
      if(rtn && rtn.stdout){
        rtn = JSON.parse(rtn.stdout);
      }
      if (rtn.status == 0) {
        await this.oplogSve.createDb({
          logLevel: "info",
          optitle: "gsbh5商标状态修改---成功",
          op: reqUrl,
          content: JSON.stringify(obj),
          resultinfo: JSON.stringify(rtn),
          clientIp: ""
        });
      } else {
        await this.oplogSve.createDb({
          logLevel: "error",
          optitle: "gsbh5商标状态修改---失败",
          op: reqUrl,
          content: JSON.stringify(obj),
          resultinfo: JSON.stringify(rtn),
          clientIp: ""
        });
        return { code: -200 };
      }
      return { code: 1 };
    } catch (e) {
      console.log(e.stack);
      await this.oplogSve.createDb({
        logLevel: "error",
        optitle: "渠道商标状态修改---异常",
        op: "app/base/db/impl/channelreceiveDao.js",
        content: JSON.stringify(obj),
        resultinfo: JSON.stringify(e.stack),
        clientIp: ""
      });
      return { code: -400, msg: "操作失败", err: e.stack };
    }
  }
  //推送辅助、担保商标注册数据
  async pushChannelAssistTmData(obj){
    try {
      var channelCode=obj.channelCode || "gsbh5";
      var channelApiUrl = this.channelApiUrl;
      channelApiUrl = settings.channelApiUrl(channelCode);
      var reqUrl = channelApiUrl + "/notifyaction/internalCallsNotify/nbtzreceiveAssistTmData";
      var rc = system.getObject("util.execClient");
      var rtn = await rc.execPost(obj, reqUrl);
      
      if(rtn && rtn.stdout){
        rtn = JSON.parse(rtn.stdout);
      }
      if (rtn.status == 0) {
        await this.oplogSve.createDb({
          logLevel: "info",
          optitle: channelCode+"辅助、担保商标注册数据推送---成功",
          op: reqUrl,
          content: JSON.stringify(obj),
          resultinfo: JSON.stringify(rtn),
          clientIp: ""
        });
      } else {
        await this.oplogSve.createDb({
          logLevel: "error",
          optitle: channelCode+"辅助、担保商标注册数据推送---失败",
          op: reqUrl,
          content: JSON.stringify(obj),
          resultinfo: JSON.stringify(rtn),
          clientIp: ""
        });
        return { code: -200 };
      }
      return { code: 1 };
    } catch (e) {
      console.log(e.stack);
      await this.oplogSve.createDb({
        logLevel: "error",
        optitle: obj.channelCode+"辅助、担保商标注册数据推送---异常",
        op: "app/base/db/impl/channelreceiveDao.js",
        content: JSON.stringify(obj),
        resultinfo: JSON.stringify(e.stack),
        clientIp: ""
      });
      return { code: -400, msg: "操作失败", err: e.stack };
    }
  }
  //推送辅助、担保商标注册修改数据
  async pushEditChannelAssistTmData(obj){
    try {
      var channelCode=obj.channelCode || "gsbh5";
      var channelApiUrl = this.channelApiUrl;
      channelApiUrl = settings.channelApiUrl(channelCode);
      var reqUrl = channelApiUrl + "/notifyaction/internalCallsNotify/nbtzreceiveEditAssistTmData";
      var rc = system.getObject("util.execClient");
      var rtn = await rc.execPost(obj, reqUrl);
      
      if(rtn && rtn.stdout){
        rtn = JSON.parse(rtn.stdout);
      }
      if (rtn.status == 0) {
        await this.oplogSve.createDb({
          logLevel: "info",
          optitle: channelCode+"辅助、担保商标注册修改数据推送---成功",
          op: reqUrl,
          content: JSON.stringify(obj),
          result: JSON.stringify(rtn),
          clientIp: ""
        });
      } else {
        await this.oplogSve.createDb({
          logLevel: "error",
          optitle: channelCode+"辅助、担保商标注册修改数据推送---失败",
          op: reqUrl,
          content: JSON.stringify(obj),
          result: JSON.stringify(rtn),
          clientIp: ""
        });
        return { code: -200 };
      }
      return { code: 1 };
    } catch (e) {
      console.log(e.stack);
      await this.oplogSve.createDb({
        logLevel: "error",
        optitle: obj.channelCode+"辅助、担保商标注册修改数据推送---异常",
        op: "app/base/db/impl/channelreceiveDao.js",
        content: JSON.stringify(e.stack),
        clientIp: ""
      });
      return { code: -400, msg: "操作失败", err: e.stack };
    }
  }
  
}
module.exports=ChannelReceiveDao;
// var task = new ChannelReceiveDao();
// var channelPushObj = {
//   orderNo:"TM34202003052259EJGx",
//   tbCode: "TB26202003091324fbjL",
//   tmStatus: "RECVCOMMIT",
//   tmStatusName:"已收提交",
//   registNumInfo:{
//     tmRegistNum: "12345678",//商标申请号
//   }
// }
// task.updateChannelTmStatus(channelPushObj).then(d=>{
//   console.log("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaa");
// })
