const CacheBase=require("../cache.base");
const system=require("../../system");

class XzgqVisitCountCache extends CacheBase{
   constructor(){
     super();
     this.accountDao=system.getObject("db.accountDao");
     this.prefix="xzgq_";
     this.desc="续展过期查询计数";
   }
   async add(companyNmae,appkey){
       var key=this.prefix+companyNmae+"_"+appkey;
       var value=await this.redisClient.incr(key);
       return value;
   }
   async get(companyName,appkey){
     var key=this.prefix+companyName+"_"+appkey;
     const value= await this.redisClient.get(key);
     if(value){
       return value;
     }else{
         await this.redisClient.set(key,0);
         return 0;
     }
   }
}
module.exports=XzgqVisitCountCache;
