const CacheBase=require("../cache.base");
const system=require("../../system");

class VisitCountCache extends CacheBase{
   constructor(){
     super();
     this.accountDao=system.getObject("db.accountDao");
     this.prefix="xz_";
     this.desc="续展查询计数";
   }
   async add(companyNmae,appkey){
       var key=this.prefix+companyNmae+"_"+appkey;
       var value=await this.redisClient.incr(key);
       return value;
   }
   async get(companyName,appkey){
     var key=this.prefix+companyName+"_"+appkey;
     const value= await this.redisClient.get(key);
     if(value){
       return value;
     }else{
         await this.redisClient.set(key,0);
         return 0;
     }
   }
   async findOnlines(appkey){
       var key="onlineset"+"￥"+"wx76a324c5d201d1a4";
       var ms=await this.redisClient.smembers(key);
       console.log("xxxxxxxxxxxxxxxxxxxxxxxxxyyyyyyyyyyyyyyyyy----appkey缓存");
       console.log(ms);
       return ms;
   }
   async exit(appkey,val){
       var key="onlineset"+"￥"+"wx76a324c5d201d1a4";
       var ms=await this.redisClient.srem(key,val);
       return ms;
   }
}
module.exports=VisitCountCache;
