const CacheBase=require("../cache.base");
const system=require("../../system");
//缓存首次登录的赠送的宝币数量
class ProductCache extends CacheBase{
   constructor(){
     super();
     this.prefix="g_products_600_";
     this.productDao=system.getObject("db.productDao");
   }
   async cacheProducts(appid){
       const key=this.prefix+appid;
       var cacheValue=await this.redisClient.get(key);
       if(!cacheValue || cacheValue=="undefined"){
         console.log("productsCache no cache....");
         cacheValue =await this.productDao.list(appid);
         await this.redisClient.setWithEx(key,JSON.stringify(cacheValue),1);
         return cacheValue;
       }else {
         console.log("uiconfig already cache....");
         return JSON.parse(cacheValue);
       }

   }
}
module.exports=ProductCache;
