const CacheBase=require("../cache.base");
const system=require("../../system");
//缓存产品访问次数
class ProductVisitCountCache extends CacheBase{
   constructor(){
     super();
     this.prefix="productVisitCount_";
     this.desc="产品访问计数";
   }
   async add(productId){
       var key=this.prefix+productId;
       var value=await this.redisClient.incr(key);
       return value;
   }
   async get(productId){
     var key=this.prefix+productId;
     const value= await this.redisClient.get(key);
     if(value){
       return value;
     }else{
         await this.redisClient.set(key,0);
         return 0;
     }
   }
}
module.exports=ProductVisitCountCache;
