const CacheBase=require("../cache.base");
const system=require("../../system");
//缓存首次登录的赠送的宝币数量
class PriceConfigCache extends CacheBase{
   constructor(){
     super();
     this.pConfigDao=system.getObject("db.pconfigDao");
     this.prefix="g_pconfig_price";
     this.desc="宝币兑换率";
   }
   async cacheGlobalVal(num,appkey){
      var key=this.prefix+"_"+appkey;
     if(num){
       this.redisClient.set(key,num);
       return num;
     }else{
       const cachedVal= await this.redisClient.get(key);
       if(cachedVal){
         return cachedVal;
       }else{
         //去查询出值并缓存
         const config=await this.pConfigDao.model.findOne({where:{configType:'price'}});
         const num2=Number(config.configValue);
         this.redisClient.set(key,num2);
         return num2;
       }
     }
   }
}
module.exports=PriceConfigCache;
