const CacheBase=require("../cache.base");
const system=require("../../system");
//缓存平台的分成比率
class InitPlatformProfitRatioCache extends CacheBase{
   constructor(){
     super();
     this.pConfigDao=system.getObject("db.pconfigDao");
     this.prefix="g_pconfig_InitPlatformProfitRatio";
   }
   async cacheGlobalVal(num){
     if(num){
       this.redisClient.set(this.prefix,num);
       return num;
     }else{
       const cachedVal= await this.redisClient.get(this.prefix);
       if(cachedVal){
         return cachedVal;
       }else{
         //去查询出值并缓存
         const config=await this.pConfigDao.model.findOne({where:{configType:'platformProfitRatio'}});
         const num2=Number(config.configValue);
         this.redisClient.set(this.prefix,num2);
         return num2;
       }
     }
   }
}
module.exports=InitPlatformProfitRatioCache;
