const CacheBase=require("../cache.base");
const system=require("../../system");
//缓存首次登录的赠送的宝币数量
class InitGiftCache extends CacheBase{
   constructor(){
     super();
     this.pConfigDao=system.getObject("db.pconfigDao");
     this.prefix="g_pconfig_initGift";
   }
   async cacheGlobalVal(num){
     if(num){
       this.redisClient.set(this.prefix,num);
       return num;
     }else{
       const cachedVal= await this.redisClient.get(this.prefix);
       if(cachedVal){
         return cachedVal;
       }else{
         //去查询出值并缓存
         const config=await this.pConfigDao.model.findOne({where:{configType:'initGift'}});
         const num2=Number(config.configValue);
         this.redisClient.set(this.prefix,num2);
         return num2;
       }
     }
   }
   async invalidateCache(){
       const key=this.prefix;
       await this.redisClient.delete(key);
   }
}
module.exports=InitGiftCache;
