const CacheBase=require("../cache.base");
const system=require("../../system");
//缓存appkey
class InitAppKeyCache extends CacheBase{
   constructor(){
     super();
     this.appDao=system.getObject("db.appDao");
     //this.globalKey="g_pconfig_initGift";
     this.prefix="appKey:appid_";
   }
   async setAppKey(appkey){
       var key=this
       this.redisClient.set(appkey,appkey);
       return appkey;
   }
   async getAppKeyVal(appkey){
     if(appkey==null || appkey==""){
       return null;
     }
     const key=this.prefix+appkey;
     const cachedVal= await this.redisClient.get(key);
     if(cachedVal){
       return cachedVal;
     }else{
       //去查询出值并缓存
       const app=await this.appDao.model.findOne({where:{appid:appkey}});
       if(app!=null && app!=""){
         await this.redisClient.set(key,app.appid);
         return app.appid;
       }else{
         return null;
       }
     }
   }
}
module.exports=InitAppKeyCache;
