const CacheBase=require("../cache.base");
const system=require("../../system");

class CheckFirstOrderCache extends CacheBase{
   constructor(){
     super();
     this.orderDao=system.getObject("db.orderDao");
     this.globalKeyPrefix="check_firstorder_";
   }
   async del(user_id){
     var key=this.globalKeyPrefix+user_id;
     await this.redisClient.delete(key);
   }
   async set(user_id,value){
       var key=this.globalKeyPrefix+user_id;
       this.redisClient.set(key,value);
       return key;
   }
   async get(user_id){
     var key=this.globalKeyPrefix+user_id;
     const value= await this.redisClient.get(key);
     if(value){
       return value;
     }else{
       var obj = {where:{"user_id": user_id}};
       var count=await this.orderDao.findCount(obj);
       console.log("countcountcountcountcountcountcount");
       console.log(count);
       if(count>0){
         await this.redisClient.set(key,false);
         return false;
       }else{
         await this.redisClient.set(key,true);
         return true;
       }
     }
   }
}
module.exports=CheckFirstOrderCache;
