const CacheBase = require("../cache.base");
const system = require("../../system");
//缓存首次登录的赠送的宝币数量
class ApplistCache extends CacheBase {
  constructor() {
    super();
    this.prefix = "fqapplist:";
    this.appDao = system.getObject("db.appDao");
  }
  async setList(values) {
    const key = his.prefix + "app_data_list";
    await this.redisClient.setWithEx(key, values, 600);//秒
    return obj;
  }
  async getListByCache() {
    const key = this.prefix + "app_data_list";
    var cachedVal = await this.redisClient.get(key);
    if (cachedVal && cachedVal != "undefined") {
      return cachedVal;
    } else {
      var appList = await this.appDao.model.findAll({
        where: { isEnabled: 1 },
        attributes: ["id", "appid", "secret", "wxcode", "name", "homePage", "authPage", "logoUrl", "app_code"], raw: true
      });
      var appListStr = JSON.stringify(appList);
      if (appListStr != null && appListStr != "") {
        await this.redisClient.setWithEx(key, appListStr, 600);//秒
        return appListStr;
      } else {
        return null;
      }
    }
  }
}
module.exports = ApplistCache;
