const CacheBase=require("../cache.base");
const system=require("../../system");

class AppletUserinfoCache extends CacheBase{
   constructor(){
     super();
     this.userDao=system.getObject("db.userDao");
     this.globalKeyPrefix="applet_userinfo_";
   }
   async del(openid){
     var key=this.globalKeyPrefix+openid;
     await this.redisClient.delete(key);
   }
   async set(openid,value){
       var key=this.globalKeyPrefix+openid;
       this.redisClient.set(key,value);
       return key;
   }
   async get(openid){
     var key=this.globalKeyPrefix+openid;
     const value= await this.redisClient.get(key);
     if(value){
       return value;
     }else{
       var user=await this.userDao.getUserByOpenId(openid);
       user=JSON.stringify(user);
       if(user!=null && user!=""){
         await this.redisClient.set(key,user);
         return user;
       }else{
         return null;
       }
     }
   }
}
module.exports=AppletUserinfoCache;
