const CacheBase=require("../cache.base");
const system=require("../../system");
//缓存所有api调用次数
class ApiCircuitBreakers extends CacheBase{
   constructor(){
     super();
   }
   async addCallCount(n){
     var key="circuitbreakers";
     var result=await this.redisClient.hincrby(key,"callcount",n);
     return result;
   }
   async getApiCall(){
     var key="circuitbreakers";
     const cachedVal= await this.redisClient.hgetall(key);
     if( cachedVal==null || cachedVal=="undefined"){
        var map={"callcount":1};
        this.redisClient.hmset(key,map);
        return map;
     }else{
       if( cachedVal.callcount < 0 ){
         var map={"callcount":1};
         this.redisClient.hmset(key,map);
         return map;
       }
        return cachedVal;
     }
   }
}
module.exports=ApiCircuitBreakers;
