const CacheBase=require("../cache.base");
const system=require("../../system");
//缓存所有api调用次数
class ApiCircuitBreakerCache extends CacheBase{
   constructor(){
     super();
   }
   async addCallCount(appkey,n){
     var result=await this.redisClient.hincrby(appkey,"callcount",n);
     return result;
   }
   async getApiCall(appkey){
     const cachedVal= await this.redisClient.hgetall(appkey);
     if( cachedVal==null || cachedVal=="undefined"){
        var map={"callcount":1};
        this.redisClient.hmset(appkey,map);
        await this.redisClient.client.expire(appkey,60);
        return map;
     }else{
       if( cachedVal.callcount < 0 ){
         var map={"callcount":1};
         this.redisClient.hmset(appkey,map);
         return map;
       }
        return cachedVal;
     }
   }
}
module.exports=ApiCircuitBreakerCache;
