const CacheBase=require("../cache.base");
const system=require("../../system");

class AccountBalanceCache extends CacheBase{
   constructor(){
     super();
     this.accountDao=system.getObject("db.accountDao");
     this.globalKeyPrefix="account_balance_";
   }
   async del(accountid,appid){
     var key=this.globalKeyPrefix+accountid+"_"+appid;
     await this.redisClient.delete(key);
   }
   async set(accountid,appid,value){
       var key=this.globalKeyPrefix+accountid+"_"+appid;
       this.redisClient.set(key,value);
       return key;
   }
   async get(accountid,appid){
     var key=this.globalKeyPrefix+accountid+"_"+appid;
     const value= await this.redisClient.get(key);
     if(value){
       return value;
     }else{
       const account=await this.accountDao.model.findOne({where:{id:accountid}});
       if(account!=null && account!=""){
         await this.redisClient.set(key,account.baoBalance);
         return account.baoBalance;
       }else{
         return null;
       }
     }
   }
}
module.exports=AccountBalanceCache;
