var System=require("../../system")
class xzsearchCtl{
  constructor(){
    this.tradeSve=System.getObject("service.tradeSve");
    this.accountSve=System.getObject("service.accountSve");
    this.appSve=System.getObject("service.appSve");
    this.productDao=System.getObject("db.productDao");
    this.gsbSearchApi=System.getObject("api.gsbtmsearch");
    this.cacheManager=System.getObject("db.cacheManager");
  }
  convertDate(time){
    if(time==null){
      return "";
    }
     var date =  new Date(Number(time*1000));
     var y = 1900+date.getYear();
     var m = "0"+(date.getMonth()+1);
     var d = "0"+date.getDate();
     return y+"-"+m.substring(m.length-2,m.length)+"-"+d.substring(d.length-2,d.length);
  }
  async findAndCountAll(queryobj,obj,req){
    var that=this;
    var appkey=req.session.app.appid;
    var result={rows:[],count:0};
    var sources=[];
    var companyName=obj.search.companyName==null?"":obj.search.companyName;
    var area=obj.search.area==null?"":obj.search.area;
    if(obj.search.endDate==null){
      var date1 = "";
      var date2 = "";
    }else{
      var date1 = obj.search.endDate[0];
      var date2 = obj.search.endDate[1];
    }
    var pageSize=obj.pageInfo.pageSize;
    var currentPage=obj.pageInfo.pageNo;
    var data={
      searchType:1,
      appKey:appkey,
      companyName:companyName,
      startDate:date1,
      endDate:date2,
      address:area,
      pageSize:pageSize,
      currentPage:currentPage
    };

    var companys =await this.gsbSearchApi.xzSearch(data);
    if(companys.status == 0){
      result.count=companys.total;
      var d=companys.data;
      for(var i=0;i<d.length;i++){
        var c=d[i];
        var source={companyName:"",companyAddr:"",email:"",phone:"",visitCount:0};
        source.companyName=c.applicant_cn;
        source.companyAddr=c.applicant_cn_addr;
        source.email=c.email_info;
        source.phone=c.tel_info;
        source.visitCount=await that.cacheManager["VisitCountCache"].get(c.applicant_cn,appkey);
        sources.push(source);
      }

      result.rows=sources;
    }
    return System.getResult2(result,null);
  }

  async getDetail(queryobj,obj,req){
    var appkey=req.session.app.appid;
    var result={rows:[],count:0};
    var sources=[];
    var companyName=obj.companyName==null?"":obj.companyName;
    if(obj.endDate==null){
      var date1 = "";
      var date2 = "";
    }else{
      var date1 = obj.endDate[0];
      var date2 = obj.endDate[1];
    }
    var data={
      searchType:1,
      appKey:appkey,
      companyName:companyName,
      startDate:date1,
      endDate:date2
    };
    var tms =await this.gsbSearchApi.xzSearchDetail(data);
    var that=this;
    if(tms.status == 0){
      tms.data.forEach(function(c){
        var source={
          regNum:c.tm_regist_num,
          tmName:c.tm_name,
          endTime:that.convertDate(c.tm_end_day),
          regMan:c.applicant_cn,
          regAddress:c.applicant_cn_addr,
          agency:c.tm_agency,
          nclOne:c.ncl_one_codes
        };
        sources.push(source);
      });
      result.rows=sources;
    }
    return System.getResult2(result,null);
  }

  async createTrade(qobj,pobj,req){
    var productId=pobj.productId;
    var companyName=pobj.companyName;
    var product=await this.productDao.model.findOne({where:{id:productId}});
    var user=req.session.user;
    var appkey=req.session.app.appid;
    var tradeObj={username:user.nickName,tradeDate:new Date(),status:"settled",baoAmount:product.price,tradeType:"consume"};
    var trade=await this.tradeSve.create(user,tradeObj);
    var accountBalance = await this.accountSve.getAccountBalance(user.account_id,user.app_id);
    trade.dataValues["accountBalance"]=accountBalance;
    var visitCount = await this.cacheManager["VisitCountCache"].add(companyName,appkey);
    trade.dataValues["visitCount"]=visitCount;
    return trade;
  }
}
module.exports=xzsearchCtl;
