var System=require("../../system");
var settings=require("../../../config/settings");
class tmqueryCtl{
  constructor(){
    this.tradeSve=System.getObject("service.tradeSve");
    this.accountSve=System.getObject("service.accountSve");
    this.appSve=System.getObject("service.appSve");
    this.productDao=System.getObject("db.productDao");
    this.GsbTmSearchApi=System.getObject("api.gsbtmsearch");
    this.tm_type={P:"普通商标",J:"集体商标",Z:"证明商标",T:"特殊商标"};
    this.tm_status={1:"有效",2:"无效",3:"待审",4:"不定",5:"未知状态"};
    this.imageQueryUrl=settings.apiconfig.imageQueryUrl();
  }
  convertDate(time){
     if(time==null){
       return "";
     }
     var date =  new Date(Number(time*1000));
     var y = 1900+date.getYear();
     var m = "0"+(date.getMonth()+1);
     var d = "0"+date.getDate();
     return y+"-"+m.substring(m.length-2,m.length)+"-"+d.substring(d.length-2,d.length);
  }
  getgjfl(key){
    var name = "";
    if(key==1){
      name = "01类 化学原料";
    }if(key==2){
      name = "02类 颜料油漆";
    }if(key==3){
      name = "03类 日化用品";
    }if(key==4){
      name = "04类 燃料油脂";
    }if(key==5){
      name = "05类 医药";
    }if(key==6){
      name = "06类 金属材料";
    }if(key==7){
      name = "07类 机械设备";
    }if(key==8){
      name = "08类 手工器械";
    }if(key==9){
      name = "09类 科学仪器";
    }if(key==10){
      name = "10类 医疗器械";
    }if(key==11){
      name = "11类 灯具空调";
    }if(key==12){
      name = "12类 运输工具";
    }if(key==13){
      name = "13类 军火烟火";
    }if(key==14){
      name = "14类 珠宝钟表";
    }if(key==15){
      name = "15类 乐器";
    }if(key==16){
      name = "16类 办公用品";
    }if(key==17){
      name = "17类 橡胶制品";
    }if(key==18){
      name = "18类 皮革皮具";
    }if(key==19){
      name = "19类 建筑材料";
    }if(key==20){
      name = "20类 家具";
    }if(key==21){
      name = "21类 厨房洁具";
    }if(key==22){
      name = "22类 绳网袋蓬";
    }if(key==23){
      name = "23类 纱线丝";
    }if(key==24){
      name = "24类 布料床单";
    }if(key==25){
      name = "25类 服装鞋帽";
    }if(key==26){
      name = "26类 钮扣拉链";
    }if(key==27){
      name = "27类 地毯席垫";
    }if(key==28){
      name = "28类 健身器材";
    }if(key==29){
      name = "29类 食品";
    }if(key==30){
      name = "30类 方便食品";
    }if(key==31){
      name = "31类 农林生鲜";
    }if(key==32){
      name = "32类 啤酒饮料";
    }if(key==33){
      name = "33类 酒";
    }if(key==34){
      name = "34类 烟草烟具";
    }if(key==35){
      name = "35类 广告销售";
    }if(key==36){
      name = "36类 金融物管";
    }if(key==37){
      name = "37类 建筑修理";
    }if(key==38){
      name = "38类 通讯服务";
    }if(key==39){
      name = "39类 运输贮藏";
    }if(key==40){
      name = "40类 材料加工";
    }if(key==41){
      name = "41类 教育娱乐";
    }if(key==42){
      name = "42类 科技服务";
    }if(key==43){
      name = "43类 餐饮住宿";
    }if(key==44){
      name = "44类 医疗园艺";
    }if(key==45){
      name = "45类 社会服务";
    }
    return name;
  }

  async findAndCountAll(queryobj,obj,req){
    var appkey=req.session.app.appid;
    var result={rows:[],count:0};
    var sources=[];
    var tmName=obj.search.tmName==null?"":obj.search.tmName;
    var regNum=obj.search.regNum==null?"":obj.search.regNum;;
    var applier=obj.search.regMan==null?"":obj.search.regMan;
    var pageSize=obj.pageInfo.pageSize;
    var currentPage=obj.pageInfo.pageNo;
    var data={
      appKey:appkey,
      tmName:tmName,
      regNum:regNum,
      applier:applier,
      pagesize:pageSize,
      page:currentPage
    };
    var tms =await this.GsbTmSearchApi.tmSearch(data);

    var that=this;
    if(tms.status == 0){
      result.count=tms.total;
      tms.data.forEach(function(tm){
        var source={
             sbmc:tm.tm_name,//商标名称
             sbpy:tm.tm_name_py,//商标拼音
             sbyw:tm.tm_name_en,//商标英文
             gjfl:tm.ncl_one_codes,//国际分类
             sbzch:tm.tm_regist_num,//商标注册号
             sblx:that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
             sbzt:that.tm_status[tm.status],//商标状态
             sqrq:that.convertDate(tm.apply_day),//申请日期
             csrq:that.convertDate(tm.first_notice_day),//初审日期
             zcrq:that.convertDate(tm.original_regist_notice_day),//注册日期
             csggym:tm.first_notice_page_num,//初审公告页码
             zcr:tm.applicant_cn,//申请人
             jzrq:that.convertDate(tm.tm_end_day) ,//截止日期
             csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
             zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
             zcggym:tm.regist_notice_page_num,//注册公告页码
             yzcr:tm.original_applicant_cn,//原申请人
             zcdz:tm.applicant_cn_addr,//申请地址
             dljg:tm.tm_agency,//代理机构
             zxzt:"",//最新状态
             spfwxm:"",
             lcxx:"",
             logo:tm.pic_url,//商标图样
        };
        sources.push(source);
      });
      result.rows=sources;
    }

    return System.getResult2(result,null);
  }

  async findAndCountAll2(queryobj,obj,req){
    var appkey=req.session.app.appid;
    var result={rows:[],count:0};
    var sources=[];
    var regNums=obj.registNums;
    // var pageSize=obj.pageInfo.pageSize==null?5:obj.pageInfo.pageSize;
    // var currentPage=obj.pageInfo.pageNo==null?1:obj.pageInfo.pageNo;
    // var from = Number((currentPage-1)*pageSize);
    // var end=Number(from+pageSize);
    if(regNums.length<1 || regNums==null){
      return System.getResult2(result,null);
    }
    //regNums.forEach(function(regNum){
    for(var i=0;i<regNums.length;i++){
      var regNum=regNums[i];
      var num=[];
      num.push(regNum.imageid);
      var data={
        appKey:appkey,
        regNums:num
      };
      var tms =await this.GsbTmSearchApi.tmSearchByRegNum(data);
      if(tms.status == 0 && tms.data.length>0){
        var tm=tms.data[0];

        var source={
             sbmc:tm.tm_name,//商标名称
             sbpy:tm.tm_name_py,//商标拼音
             sbyw:tm.tm_name_en,//商标英文
             gjfl:tm.ncl_one_codes,//国际分类
             sbzch:tm.tm_regist_num,//商标注册号
             sblx:this.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
             sbzt:this.tm_status[tm.status],//商标状态
             sqrq:this.convertDate(tm.apply_day),//申请日期
             csrq:this.convertDate(tm.first_notice_day),//初审日期
             zcrq:this.convertDate(tm.original_regist_notice_day),//注册日期
             csggym:tm.first_notice_page_num,//初审公告页码
             zcr:tm.applicant_cn,//申请人
             jzrq:this.convertDate(tm.tm_end_day) ,//截止日期
             csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
             zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
             zcggym:tm.regist_notice_page_num,//注册公告页码
             yzcr:tm.original_applicant_cn,//原申请人
             zcdz:tm.applicant_cn_addr,//申请地址
             dljg:tm.tm_agency,//代理机构
             zxzt:"",//最新状态
             spfwxm:"",
             lcxx:"",
             logo:tm.pic_url,//商标图样
             xsd:Number((1-regNum.distance)*100).toFixed(2)+"%",
        };
        sources.push(source);
      }else{
        var source={
             sbmc:"暂无",//商标名称
             sbpy:"暂无",//商标拼音
             sbyw:"暂无",//商标英文
             gjfl:"暂无",//国际分类
             sbzch:regNum.imageid,//商标注册号
             sblx:"暂无",//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
             sbzt:"暂无",//商标状态
             sqrq:"暂无",//申请日期
             csrq:"暂无",//初审日期
             zcrq:"暂无",//注册日期
             csggym:"暂无",//初审公告页码
             zcr:"暂无",//申请人
             jzrq:"暂无",//截止日期
             csggqh:"暂无",//初审公告（期号）
             zcggqh:"暂无",//注册公告
             zcggym:"暂无",//注册公告页码
             yzcr:"暂无",//原申请人
             zcdz:"暂无",//申请地址
             dljg:"暂无",//代理机构
             zxzt:"暂无",//最新状态
             spfwxm:"暂无",
             lcxx:"暂无",
             logo:"",//商标图样
             xsd:"暂无",
        };
        sources.push(source);
      }
    };

    result.count=regNums.length;
    result.rows=sources;

    return System.getResult2(result,null);

  }


  async findTrademarkName(queryobj,obj,req){//根据商标名称模糊查询
    var appkey=req.session.app.appid;
    var result={rows:[],code_counts:[],count:0};
    var sources=[];
    var codes=[];
    var tmName=obj.tmName==null?"":obj.tmName;
    var sqlbtabkey = obj.sqlbtabkey==null?"":obj.sqlbtabkey;
    var pageSize=obj.pageSize;
    var currentPage=obj.currentPage;
    var data={
      appKey:appkey,
      tmName:tmName,
      sqlbtabkey:sqlbtabkey,
      pagesize:pageSize,
      page:currentPage
    };
    var tms =await this.GsbTmSearchApi.tmNameSearch(data);//获取查询结果
    var tmsjuhe = await this.GsbTmSearchApi.tmNamejuheSearch(data);//获取聚合结果
    var that=this;
    if(tms.status == 0){
      result.count=tms.total;
      tms.data.forEach(function(tm){
        var source={
             sbmc:tm.tm_name,//商标名称
             sbpy:tm.tm_name_py,//商标拼音
             sbyw:tm.tm_name_en,//商标英文
             gjfl:tm.ncl_one_codes,//国际分类
             sbzch:tm.tm_regist_num,//商标注册号
             sblx:that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
             sbzt:that.tm_status[tm.status],//商标状态
             sqrq:that.convertDate(tm.apply_day),//申请日期
             csrq:that.convertDate(tm.first_notice_day),//初审日期
             zcrq:that.convertDate(tm.original_regist_notice_day),//注册日期
             csggym:tm.first_notice_page_num,//初审公告页码
             zcr:tm.applicant_cn,//申请人
             jzrq:that.convertDate(tm.tm_end_day) ,//截止日期
             csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
             zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
             zcggym:tm.regist_notice_page_num,//注册公告页码
             yzcr:tm.original_applicant_cn,//原申请人
             zcdz:tm.applicant_cn_addr,//申请地址
             dljg:tm.tm_agency,//代理机构
             zxzt:"",//最新状态
             spfwxm:"",
             lcxx:"",
             logo:tm.pic_url,//商标图样
        };
        sources.push(source);

      });
      result.rows=sources;
    }
    if(tmsjuhe.status==0){
      tmsjuhe.buckets.sort(function(a,b){
        return a.key - b.key;
      });
      tmsjuhe.buckets.forEach(function(buck){

            var name = that.getgjfl(buck.key);
            var gjfl ={//国际分类
            	"key":buck.key,
            	"keyvalue":name,
            	"keycount":buck.doc_count,
            };
            codes.push(gjfl);
      });
      result.code_counts=codes;
    }
    return System.getResult2(result,null);
  }

  async findTrademarkNameAccurate(queryobj,obj,req){//通过商标名来进行精准查询
    var appkey=req.session.app.appid;
    var result={rows:[],code_counts:[],count:0};
    var sources=[];
    var codes=[];
    var tmName=obj.tmName==null?"":obj.tmName;
    var sqlbtabkey = obj.sqlbtabkey==null?"":obj.sqlbtabkey;
    var pageSize=obj.pageSize;
    var currentPage=obj.currentPage;
    var data={
      appKey:appkey,
      tmName:tmName,
      sqlbtabkey:sqlbtabkey,
      pagesize:pageSize,
      page:currentPage
    };
    var tms =await this.GsbTmSearchApi.tmAccurateSearch(data);//获取查询结果
    var tmsjuhe = await this.GsbTmSearchApi.tmAccurateJuheSearch(data);//获取聚合结果
    var that=this;
    if(tms.status == 0){
      result.count=tms.total;
      tms.data.forEach(function(tm){
        var source={
             sbmc:tm.tm_name,//商标名称
             sbpy:tm.tm_name_py,//商标拼音
             sbyw:tm.tm_name_en,//商标英文
             gjfl:tm.ncl_one_codes,//国际分类
             sbzch:tm.tm_regist_num,//商标注册号
             sblx:that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
             sbzt:that.tm_status[tm.status],//商标状态
             sqrq:that.convertDate(tm.apply_day),//申请日期
             csrq:that.convertDate(tm.first_notice_day),//初审日期
             zcrq:that.convertDate(tm.original_regist_notice_day),//注册日期
             csggym:tm.first_notice_page_num,//初审公告页码
             zcr:tm.applicant_cn,//申请人
             jzrq:that.convertDate(tm.tm_end_day) ,//截止日期
             csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
             zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
             zcggym:tm.regist_notice_page_num,//注册公告页码
             yzcr:tm.original_applicant_cn,//原申请人
             zcdz:tm.applicant_cn_addr,//申请地址
             dljg:tm.tm_agency,//代理机构
             zxzt:"",//最新状态
             spfwxm:"",
             lcxx:"",
             logo:tm.pic_url,//商标图样
        };
        sources.push(source);

      });
      result.rows=sources;
    }
    if(tmsjuhe.status==0){
      tmsjuhe.buckets.sort(function(a,b){
        return a.key - b.key;
      });
      tmsjuhe.buckets.forEach(function(buck){
            var name = that.getgjfl(buck.key);
            var gjfl ={//国际分类
            	"key":buck.key,
            	"keyvalue":name,
            	"keycount":buck.doc_count,
            };
            codes.push(gjfl);
      });
      result.code_counts=codes;
    }
    console.log("--------------------------------");
    console.log(result);

    return System.getResult2(result,null);
  }

  async findTrademarkzchAccurate(queryobj,obj,req){//通过商标号来进行精准查询
    var appkey=req.session.app.appid;
    var result={rows:[],code_counts:[],count:0};
    var sources=[];
    var codes=[];
    var regNum=obj.regNum==null?"":obj.regNum;
    var sqlbtabkey = obj.sqlbtabkey==null?"":obj.sqlbtabkey;
    var pageSize=obj.pageSize;
    var currentPage=obj.currentPage;
    var data={
      appKey:appkey,
      regNum:regNum,
      sqlbtabkey:sqlbtabkey,
      pagesize:pageSize,
      page:currentPage
    };
    var tms =await this.GsbTmSearchApi.tmzchSearch(data);//获取查询结果
    var tmsjuhe = await this.GsbTmSearchApi.tmzchjuheSearch(data);//获取聚合结果
    var that=this;
    if(tms.status == 0){
      result.count=tms.total;
      tms.data.forEach(function(tm){
        var source={
             sbmc:tm.tm_name,//商标名称
             sbpy:tm.tm_name_py,//商标拼音
             sbyw:tm.tm_name_en,//商标英文
             gjfl:tm.ncl_one_codes,//国际分类
             sbzch:tm.tm_regist_num,//商标注册号
             sblx:that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
             sbzt:that.tm_status[tm.status],//商标状态
             sqrq:that.convertDate(tm.apply_day),//申请日期
             csrq:that.convertDate(tm.first_notice_day),//初审日期
             zcrq:that.convertDate(tm.original_regist_notice_day),//注册日期
             csggym:tm.first_notice_page_num,//初审公告页码
             zcr:tm.applicant_cn,//申请人
             jzrq:that.convertDate(tm.tm_end_day) ,//截止日期
             csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
             zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
             zcggym:tm.regist_notice_page_num,//注册公告页码
             yzcr:tm.original_applicant_cn,//原申请人
             zcdz:tm.applicant_cn_addr,//申请地址
             dljg:tm.tm_agency,//代理机构
             zxzt:"",//最新状态
             spfwxm:"",
             lcxx:"",
             logo:tm.pic_url,//商标图样
        };
        sources.push(source);

      });
      result.rows=sources;
    }
    if(tmsjuhe.status==0){
      tmsjuhe.buckets.sort(function(a,b){
        return a.key - b.key;
      });
      tmsjuhe.buckets.forEach(function(buck){
            var name = that.getgjfl(buck.key);
            var gjfl ={//国际分类
            	"key":buck.key,
            	"keyvalue":name,
            	"keycount":buck.doc_count,
            };
            codes.push(gjfl);
      });
      result.code_counts=codes;
    }
    return System.getResult2(result,null);
  }

  async findTrademarkzcr(queryobj,obj,req){//通过注册人模糊查询
    var appkey=req.session.app.appid;
    var result={rows:[],code_counts:[],count:0};
    var sources=[];
    var codes=[];
    var applier=obj.regMan==null?"":obj.regMan;
    var sqlbtabkey = obj.sqlbtabkey==null?"":obj.sqlbtabkey;
    var pageSize=obj.pageSize;
    var currentPage=obj.currentPage;
    var data={
      appKey:appkey,
      applier:applier,
      sqlbtabkey:sqlbtabkey,
      pagesize:pageSize,
      page:currentPage
    };

    var tms =await this.GsbTmSearchApi.tmzcrSearch(data);//获取查询结果
    var tmsjuhe = await this.GsbTmSearchApi.tmzcrjuheSearch(data);//获取聚合结果

    var that=this;
    if(tms.status == 0){
      result.count=tms.total;
      tms.data.forEach(function(tm){
        var source={
             sbmc:tm.tm_name,//商标名称
             sbpy:tm.tm_name_py,//商标拼音
             sbyw:tm.tm_name_en,//商标英文
             gjfl:tm.ncl_one_codes,//国际分类
             sbzch:tm.tm_regist_num,//商标注册号
             sblx:that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
             sbzt:that.tm_status[tm.status],//商标状态
             sqrq:that.convertDate(tm.apply_day),//申请日期
             csrq:that.convertDate(tm.first_notice_day),//初审日期
             zcrq:that.convertDate(tm.original_regist_notice_day),//注册日期
             csggym:tm.first_notice_page_num,//初审公告页码
             zcr:tm.applicant_cn,//申请人
             jzrq:that.convertDate(tm.tm_end_day) ,//截止日期
             csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
             zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
             zcggym:tm.regist_notice_page_num,//注册公告页码
             yzcr:tm.original_applicant_cn,//原申请人
             zcdz:tm.applicant_cn_addr,//申请地址
             dljg:tm.tm_agency,//代理机构
             zxzt:"",//最新状态
             spfwxm:"",
             lcxx:"",
             logo:tm.pic_url,//商标图样
        };
        sources.push(source);

      });
      result.rows=sources;
    }
    if(tmsjuhe.status==0){
      tmsjuhe.buckets.sort(function(a,b){
        return a.key - b.key;
      });
      tmsjuhe.buckets.forEach(function(buck){
            var name = that.getgjfl(buck.key);
            var gjfl ={//国际分类
            	"key":buck.key,
            	"keyvalue":name,
            	"keycount":buck.doc_count,
            };
            codes.push(gjfl);
      });
      result.code_counts=codes;
    }
    return System.getResult2(result,null);
  }

  async imagequery(obj){
    var result={rows:[],code_counts:[],count:0};
    var sources=[];
    var key=settings.apiconfig.imageQueryKey;
    var tmUrl=obj.imageUrl;
    var url=this.imageQueryUrl+"?imageurl="+encodeURIComponent(tmUrl)+"&appkey="+key;
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execGet({},url);
      var data=JSON.parse(rtn.stdout);
      if(data[0].length && data[0].length>0 && data[0]!=undefined){
        var d=data[0];
        result.rows=d;
        var codes=[];
        var RegistNumsAll=[];
        for(var i=0;i<d.length;i++){
          var regNum=d[i];
          RegistNumsAll.push(regNum.imageid);
        }
        var data={
          tmRegistNumsAll:RegistNumsAll,
        };
        var tmsjuhe = await this.GsbTmSearchApi.imagesearchjuhe(data);//获取聚合结果
        var that=this;
        if(tmsjuhe.status==0){
          tmsjuhe.buckets.sort(function(a,b){
            return a.key - b.key;
          });
          tmsjuhe.buckets.forEach(function(buck){
                var name = that.getgjfl(buck.key);
                var gjfl ={//国际分类
                	"key":buck.key,
                	"keyvalue":name,
                	"keycount":buck.doc_count,
                };
                codes.push(gjfl);
          });
          result.code_counts=codes;
        }
        result.count=d.length;
        return System.getResult2(result,null);
      }
      return System.getResult2(result,null);
    }catch(e){
      console.log(e);
      return System.getResult2(result,null);
    }
    return System.getResult2(result,null);
  }

  async getTmFlowByRegNum(queryobj,obj,req){
    var appkey=req.session.app.appid;
    var result={rows:[],count:0};
    var sources=[];
    var regNum=obj.regNum==null?"":obj.regNum;

    var data={
      appKey:appkey,
      regNum:regNum
    };
    var tms =await this.GsbTmSearchApi.getTmFlow(data);
    var that=this;
    var lcxx="";
    if(tms.status == 0){
      tms.data.forEach(function(c){
        var date=that.convertDate(c.notice_data)
        lcxx=lcxx+date+" "+c.notice_type_name+"\n";
      });
    }
    return lcxx;
  }

  async getTmNclSmallCodesByRegNum(queryobj,obj,req){
    var appkey=req.session.app.appid;
    var result={rows:[],count:0};
    var sources=[];
    var regNum=obj.regNum==null?"":obj.regNum;
    var nclOneCode=obj.nclOneCode==null?"":obj.nclOneCode;

    var data={
      appKey:appkey,
      regNum:regNum,
      nclOneCode:nclOneCode
    };
    var tms =await this.GsbTmSearchApi.getTmNclSmallCodes(data);
    var that=this;
    var spfwxm="";
    if(tms.status == 0){
      tms.data.forEach(function(c){
        spfwxm=spfwxm+c.ncl_last+"; ";
      });
    }
    return spfwxm;
  }

  async createTrade(qobj,pobj,req){
    var productId=pobj.productId;
    var product=await this.productDao.model.findOne({where:{id:productId}});
    var user=req.session.user;
    var tradeObj={username:user.nickName,tradeDate:new Date(),status:"settled",baoAmount:product.price,tradeType:"consume"};
    var trade=await this.tradeSve.create(user,tradeObj);
    var accountBalance = await this.accountSve.getAccountBalance(user.account_id,user.app_id);
    trade.dataValues["accountBalance"]=accountBalance;
    return trade;
  }
  async findImageSearch(queryobj,obj,req){ //图像检索查询，
    var appkey=req.session.app.appid;
    var result={rows:[],count:0};
    var sources=[];
    var cp = obj.pageInfo.pageNo;
    var ps = obj.pageInfo.pageSize;
    var sqlbtabkey = obj.sqlbtabkey==null?"":obj.sqlbtabkey;
    var tmRegistNumsAll = obj.tmRegistNumsAll==null?"":obj.tmRegistNumsAll;
    var RegistNumsAll=[];
    for(var i=0;i<tmRegistNumsAll.length;i++){
      var regNum=tmRegistNumsAll[i];
      RegistNumsAll.push(regNum.imageid);
    }
    var from = Number((cp-1)*ps);
    var end=Number(from+ps);
    var tmRegistNums=RegistNumsAll.slice(from,end);
    if(sqlbtabkey==""||sqlbtabkey==null){
      for(var i=0;i<tmRegistNums.length;i++){
        var regNum=tmRegistNums[i];
        var data1={
          appKey:appkey,
          tmRegistNum:regNum,
          sqlbtabkey:sqlbtabkey
        };
        var tms =await this.GsbTmSearchApi.imagesearch(data1);
        if(tms.status == 0 && tms.data.length>0){
          var tm=tms.data[0];
          var source={
            sbmc:tm.tm_name,//商标名称
            sbpy:tm.tm_name_py,//商标拼音
            sbyw:tm.tm_name_en,//商标英文
            gjfl:tm.ncl_one_codes,//国际分类
            sbzch:tm.tm_regist_num,//商标注册号
            sblx:this.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
            sbzt:this.tm_status[tm.status],//商标状态
            sqrq:this.convertDate(tm.apply_day),//申请日期
            csrq:this.convertDate(tm.first_notice_day),//初审日期
            zcrq:this.convertDate(tm.original_regist_notice_day),//注册日期
            csggym:tm.first_notice_page_num,//初审公告页码
            zcr:tm.applicant_cn,//申请人
            jzrq:this.convertDate(tm.tm_end_day) ,//截止日期
            csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
            zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
            zcggym:tm.regist_notice_page_num,//注册公告页码
            yzcr:tm.original_applicant_cn,//原申请人
            zcdz:tm.applicant_cn_addr,//申请地址
            dljg:tm.tm_agency,//代理机构
            zxzt:"",//最新状态
            spfwxm:"",
            lcxx:"",
            logo:tm.pic_url,//商标图样
          };
          sources.push(source);
        }
      }
      result.rows=sources;
      result.count=tmRegistNumsAll.length;
      return System.getResult2(result,null);
    }else {
      var data={
        appKey:appkey,
        tmRegistNumsAll:RegistNumsAll,
        sqlbtabkey:sqlbtabkey,
        pagesize:ps,
        page:cp
      };
      var tms =await this.GsbTmSearchApi.imagesearchbycode(data);
      var that=this;
      if(tms.status == 0 && tms.data.length>0){
        result.count=tms.total;
        tms.data.forEach(function(tm){
          var source={
               sbmc:tm.tm_name,//商标名称
               sbpy:tm.tm_name_py,//商标拼音
               sbyw:tm.tm_name_en,//商标英文
               gjfl:tm.ncl_one_codes,//国际分类
               sbzch:tm.tm_regist_num,//商标注册号
               sblx:that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
               sbzt:that.tm_status[tm.status],//商标状态
               sqrq:that.convertDate(tm.apply_day),//申请日期
               csrq:that.convertDate(tm.first_notice_day),//初审日期
               zcrq:that.convertDate(tm.original_regist_notice_day),//注册日期
               csggym:tm.first_notice_page_num,//初审公告页码
               zcr:tm.applicant_cn,//申请人
               jzrq:that.convertDate(tm.tm_end_day) ,//截止日期
               csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
               zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
               zcggym:tm.regist_notice_page_num,//注册公告页码
               yzcr:tm.original_applicant_cn,//原申请人
               zcdz:tm.applicant_cn_addr,//申请地址
               dljg:tm.tm_agency,//代理机构
               zxzt:"",//最新状态
               spfwxm:"",
               lcxx:"",
               logo:tm.pic_url,//商标图样
          };
          sources.push(source)
        });
      }
      result.rows=sources;
      return System.getResult2(result,null);
    }
  }


}
module.exports=tmqueryCtl;
