var System = require("../../system");
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");

class tmflowCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(tmflowCtl));
  }
  async getDetail(queryobj, obj, req) {
    var user = req.session.user;
    if (user == null && req.headers.access_source!="zqq1571212637509") {
      return { code: "-100", msg: "用户未登录" };
    }
    var tmRegistNum = obj.tmRegistNum == null ? "" : obj.tmRegistNum;
    return await this.service.getDetailList(1, 20, tmRegistNum);
  }
  async putReturnReceip(queryobj, obj, req) {
    var user = req.session.user;
    var dataList = obj.urlList;
    var officialＴype = obj.officialＴype;
    if (user == null) {
      return { code: "-100", msg: "用户未登录" };
    }
    if (dataList == null || dataList.length == 0) {
      return { code: "-110", msg: "参数有误" };
    }
    if (dataList.length > 1000) {
      return { code: "-120", msg: "抱歉，一次只能选择1000个文件进行状态更新" };
    }
    // return await this.service.setReturnReceip(user, dataList);
    return await this.service.setReturnReceip_new(user, dataList, officialＴype);
  }

}
module.exports = tmflowCtl;
