var system=require("../../system")
var settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);

const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
const md5 = require("MD5");
class TmcompanyCtl extends CtlBase{
   constructor(){
     super(CtlBase.getServiceName(TmcompanyCtl));
     this.appSve=system.getObject("service.appSve");
     this.userSve=system.getObject("service.userSve");
   }

   async validAccount(queryobj,qobj,req) {
     let account = qobj.account || "";
     let id = Number(qobj.id || 0);

     if(!account) {
       return system.getErrResult2("请填写公司帐号");
     }

     let all = await this.service.findAll({account:account});
     if(!all || all.length == 0) {
       return system.getResult2(true);
     }

     if(!id || all.length > 1) {
       return system.getErrResult2("帐号已存在, 请修改重试");
     }

     if(id != all[0].id) {
       return system.getErrResult2("帐号已存在, 请修改重试");
     }
     return system.getResult2(true);
   }

   async saveApply(queryobj,qobj,req){
     try {
       let userId = req.session.user.id;
       let app = req.session.app;
       let loginUser = await this.userSve.findById(userId);

       var old=null;
       let id = qobj.id;
       qobj.auditStatus = '0';
       qobj.auditStatusName = '待审核';
       qobj.passwd = md5(qobj.passwd + app.secret);

       if(id) {
         old = await this.service.findById(id);
         old.auditStatus = qobj.auditStatus;
         old.name = qobj.name;
         old.account = qobj.account;
         old.passwd = qobj.passwd;
         old.useCount = qobj.useCount;
         old.payVoucher = qobj.useCount;
         old.contact = qobj.contact;
         old.auditStatusName = qobj.auditStatusName;
       }

       var rtn = null;
       if(old){//修改
         console.log("edit++++++++++++++++++++++++++++++++++++");
         await this.service.update(qobj);
         rtn = await this.service.findById(id);
       }else{//新增
         qobj.ownerId = userId;
         console.log("new++++++++++++++++++++++++++++++++++++");
         rtn = await this.service.create(qobj);

         loginUser.tm_company_id = rtn.id;
         loginUser.tm_copmpany_name = rtn.name;
         loginUser.save();
       }

       return system.getResult2(rtn, null);
     } catch (e) {
       console.log("-----------------------------e");
       console.log(e);
       return {code:-1}
     }
   }

   async bind(queryobj,qobj,req) {
     let account = qobj.account || "";
     let passwd = qobj.passwd || "";

     let userId = req.session.user.id;
     let app = req.session.app;
     let loginUser = await this.userSve.findById(userId);
     if(loginUser.tm_company_id) {
       return system.getErrResult2("已绑定帐号, 不可以重复绑定");
     }

     var tmcompany = await this.service.findOne({account : account});
     if(!tmcompany || md5(passwd + app.secret) != tmcompany.passwd) {
       return system.getErrResult2("帐号或密码错误");
     }

     if(tmcompany.auditStatus == '0') {
       return system.getErrResult2("帐号审核中, 请耐心等待");
     }

     if(tmcompany.auditStatus == '2') {
       return system.getErrResult2("帐号被驳回, 请重新提交审核");
     }

     if(tmcompany.auditStatus == '3' || !tmcompany.valid_at || new Date() > tmcompany.valid_at) {
       tmcompany.auditStatus = '3';
       tmcompany.auditStatusName = '过期';
       tmcompany.save();
       return system.getErrResult2("帐号已过期");
     }

     var useCount = tmcompany.useCount;
     var total = await this.userSve.findCount({where:{tm_company_id: tmcompany.id}});
     if(total >= useCount) {
       return system.getErrResult2("对不起, 该企业帐号使用人数不可超过" + useCount + "个");
     }

     loginUser.tm_company_id = tmcompany.id;
     loginUser.tm_company_name = tmcompany.name;
     loginUser.save();

     return system.getResult2(true);
   }

   async pass(queryobj,qobj,req) {
     var id = qobj.id || 0;

     var tc = await this.service.findById(id);

     if(tc.auditStatus != '0') {
       return system.getErrResult2("订单已审核完成");
     }

     var valid_at = new Date();
     valid_at.setFullYear(valid_at.getFullYear()+1);

     tc.audit_id = req.session.user.id;
     tc.audit_at = new Date();
     tc.auditStatus = '1';
     tc.auditStatusName = '审核通过';
     tc.valid_at = valid_at;
     tc.save();

     return system.getResult2(tc);
   }

   async reject(queryobj, qobj, req) {
     var id = qobj.id || 0;

     var tc = await this.service.findById(id);
     if(tc.auditStatus != '0') {
       return system.getErrResult2("订单已审核完成");
     }

     tc.audit_id = req.session.user.id;
     tc.audit_at = new Date();
     tc.auditStatus = '2';
     tc.auditStatusName = '审核驳回';
     tc.audit_reason = qobj.auditReason;
     tc.save();

     return system.getResult2(tc);
   }
 }
module.exports=TmcompanyCtl;
