var system=require("../../system")
var settings=require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
const logCtl=system.getObject("web.oplogCtl");
class ServiceTypeCtl extends CtlBase{
   constructor(){
     super(CtlBase.getServiceName(ServiceTypeCtl));
     this.servicetypeSve=system.getObject("service.servicetypeSve");
   }
   async initNewInstance(queryobj,qobj){
     var u=uuidv4();
     var aid=u.replace(/\-/g,"");
     var rd={name:"",code:aid}
     return system.getResult2(rd,null);
   }
   async createOrEdit(queryobj,qobj,req){
     try {
       return await this.servicetypeSve.createOrEdit(qobj);
     } catch (e) {
       console.log("-----------------------------e");
       console.log(e);
       return {code:-1}
     }
   }
   async findAllType(qobj,obj,req){
     var self=this;
     var tObj={p_id:0,channel_code:obj.channel_code}
     var list=await this.service.getListByPid(tObj);
      list.data.push({id:-1,name:"一级分类"});
      list.data.sort(self.keysort('id',false));
      return list;
   }
   /**
     * 排序有倒序 对数组中的对象，按对象的key进行sortType排序
     * @param key 数组中的对象为object,按object中的key进行排序
     * @param sortType true为降序；false为升序
     */
   keysort(key,sortType) {
        return function(a,b){
            return sortType ? ~~(a[key] < b[key]) : ~~(a[key] > b[key]);
        }
    }
}
module.exports=ServiceTypeCtl;
