var system=require("../../system")
var settings=require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
const logCtl=system.getObject("web.oplogCtl");
class ServicesitemCtl extends CtlBase{
   constructor(){
     super(CtlBase.getServiceName(ServicesitemCtl));
     //this.appS=system.getObject("service.appSve");
     this.shopserviceitemS=system.getObject("service.shopserviceitemSve");
     this.channelSve=system.getObject("service.channelSve");
   }
   //渠道对应产品列表获取
   async findByChannelcode(qobj,obj,req){
     if(obj.channelcode==""||obj.channelcode==null||obj.channelcode=="undefined"){
       return {code:-1,msg:"参数channelcode错误"};
     }
     var channel=await this.channelSve.getChannelItem(obj.channelcode);
     if(channel==""||channel==null||channel=="undefined"){
       return {code:-1,msg:"该渠道尚未建立"};
     };
     var channelname=channel.channelName;
     var servicesitem=await this.service.findByChannelcode(obj);
     return {code:1,msg:"成功",data:{channelname:channelname,data:servicesitem}};
   }

   async initNewInstance(queryobj,qobj){
     var u=uuidv4();
     var aid=u.replace(/\-/g,"");
     var rd={name:"",appid:aid}
     return system.getResult2(rd,null);
   }
   async findService5(queryobj,qobj){
     var rd=await this.service.findService5();
     return system.getResult2(rd,null);
   }
   async  findById(q,oid){
      return super.findById(Number(oid.id));
   }

   async replenishServiceItem(obj,req){
     var channel =req.channel==null||req.channel==""||req.channel=="undefined"?"hhr":req.channel;
     try {
       var r=await this.shopserviceitemS.replenishServiceItem(channel);
       return r;
     } catch (e) {
       console.log(e.stack);
       //日志记录
       logCtl.error({
         optitle:"补货操作异常error:channel="+channel,
         op:"base/controller/impl/servicesitemCtl/replenishServiceItem",
         content:e.stack,
         clientIp:""
       });
       return {
            code: -200,
            message: "补货异常",
            data: {}
         };
     }
   }
   async opCopyData(gobj,pobj,req){
     try {
       var user=req.session.user;
       if(user==null){
         return {
              code: 1,
              message: "补货异常",
              data:""
           };
       }
       var r=await this.service.copyServiceItemData(pobj,user.onlyCode);
       console.log("ret-----------------------------------");
       console.log(r);
       return r;
     } catch (e) {
       console.log("----------------------------------------------------------------error-------------------");
       console.log(e.stack);
       //日志记录
       logCtl.error({
         optitle:"复制数据异常error",
         op:"base/controller/impl/servicesitemCtl/opCopyData",
         content:"请求参数："+JSON.stringify(pobj)+"，异常error："+e.stack,
         clientIp:""
       });
       console.log("----------------------------------------------------------------error-------------------00000000000000001111111111111111");
       return {
            code: -200,
            message: "复制数据异常",
            data: ""
         };
     }
   }

   async getRecommendProducts(gobj,pobj,req){
     var channelCode = pobj.channelCode || "";
     let list = await this.service.findAll({channelCode : channelCode, isRecommend : '1', isPubed : true});
     if(list.length == 0) {
       return system.getResult2(list);
     }

     let itemMap = new Array();
     for (var item of list) {
       var l = itemMap[item.itemType];
       if(!l) {
         l = {
           itemType : item.itemType,
           itemTypeName : item.itemTypeName,
           productList : []
         };
       }
       l.productList.push(item);
       itemMap[item.itemType] = l;
     }

     let result = [];
     for(var idx in itemMap) {
       result.push(itemMap[idx]);
     }
     return system.getResult2(result);
   }

   async getAllProducts(gobj,pobj,req){
     try {
       var channelCode = pobj.channelCode || "";
       let list = await this.service.findAll({channelCode : channelCode, isPubed : true});
       if(list.length == 0) {
         return system.getResult2(list);
       }
       let itemMap = new Array();
       let smallMap = [];
       for (var item of list) {
         var obj = itemMap[item.itemType];
         if(!obj) {
           obj = {
             itemType : item.itemType,
             itemTypeName : item.itemTypeName,
             smallList : []
           };
         }
         var bool = true;
         for(let sm of obj.smallList) {
           if(sm.serviceSmallClassType == item.serviceSmallClassType) {
             bool = false;
             break;
           }
         }
         if(bool) {
           obj.smallList.push({
             serviceSmallClassType : item.serviceSmallClassType,
             serviceSmallClassTypeName : item.serviceSmallClassTypeName,
           });
         }
         itemMap[item.itemType] = obj;
         // console.log(obj, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++obj");

         var small = smallMap[item.serviceSmallClassType];
         if(!small) {
           small = [];
         }
         small.push(item);
         smallMap[item.serviceSmallClassType] = small;
       }

       var result  = [];
       for(var idx in itemMap) {
         var big = itemMap[idx];
         if(big) {
           console.log(big.smallList, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++bigobj");
           for(var sm of big.smallList) {
             if(sm) {
               console.log( sm.productList, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++sm");
               sm.productList = smallMap[sm.serviceSmallClassType];
             }
           }
         }
         result.push(big);
       }

       return system.getResult2(result);
     } catch (e) {
       console.log(e, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++error ");
     } finally {

     }

   }
}
module.exports=ServicesitemCtl;
