var system=require("../../system")
const http=require("http")
const querystring = require('querystring');
var settings=require("../../../config/settings");
const CtlBase = require("../ctl.base");
class ProductCtl extends CtlBase{
   constructor(){
     super(CtlBase.getServiceName(ProductCtl));
     this.cacheManager=system.getObject("db.cacheManager");
     //this.productS=system.getObject("service.productSve");
   }
   async list(){
     var products=await this.service.list(settings.wxconfig.appId);
     return system.getResult2(products);
   }
   //增加产品访问计数
   async addVisitCount(gobj,pobj,req){
     var productid=pobj.productId;
     var visitCount=await this.cacheManager["ProductVisitCountCache"].add(productid);
     return visitCount;
   }
   //获取产品访问计数
   async getVisitCount(productid){
     var visitCount=await this.cacheManager["ProductVisitCountCache"].get(productid);
     return visitCount;
   }
   //产品数据中添加访问次数数据
   async addVisitCountData(products){
     //var products=pobj.products;
     for(var i=0;i<products.length;i++){
       if(products[i] && products[i].dataValues){
         var count=await this.getVisitCount(products[i].dataValues.id);
         products[i].dataValues.useSta=count;
       }
     }
     return products;
   }
}
module.exports=ProductCtl;
