var System=require("../../system");
var settings=require("../../../config/settings");
class pdf2wordCtl{
  constructor(){
      this.p2wUrl=settings.apiconfig.pdf2wordUrl();
      this.accountSve=System.getObject("service.accountSve");
      this.attachmentSve=System.getObject("service.attachmentSve");

      this.userDao=System.getObject("db.userDao");
      this.accountDao=System.getObject("db.accountDao");
      this.productDao=System.getObject("db.productDao");

  }
  async pdf2word(obj){
    var reqUrl=this.p2wUrl;
    var filekey=obj.key;
    if(filekey==null || filekey==""){
      System.getResult2(null,null);
    }
    var param={"key":filekey};
     var rc=System.getObject("util.execClient");
     var rtn=null;
     try{
       rtn=await rc.execPost(param,reqUrl);
       var j=JSON.parse(rtn.stdout);
       if(j.res.status && j.res.status==200){
         return j.url;
       }else{
          return null;
       }
       // return "http://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_pdf2word94715337960293212018914279321.doc"
     }catch(e){
       return null;
     }
     return null;
  }

  async createAttachment(queryobj,pobj,req){
    var productId=pobj.productId;
    var key=pobj.key;
    var originUrl=pobj.pdfUrl;
    var transformUrl=pobj.docUrl;
    var filename=pobj.filename;
    var product=await this.productDao.model.findOne({where:{id:productId}});
    var user=req.session.user;
    var accountId=user.account_id;
    var app=req.session.app;
    var usr =await this.userDao.model.findOne({where:{id:user.id}});
    var account=await this.accountDao.model.findOne({where:{id:accountId}});
    var attachmentObj={
      key:key,
      name:filename,
      originUrl:originUrl,
      transformUrl:transformUrl,
      userId:user.id,
      userName:user.nickName,
      appid:app.id,
      appName:app.name,
      user:usr,
      account:account,
      productId:productId
    };
    var att =await this.attachmentSve.create(attachmentObj);

    await this.accountSve.delAccountBalance(user.account_id,user.app_id);
    var accountBalance =await this.accountSve.getAccountBalance(user.account_id,user.app_id);
    att.dataValues["price"]=product.price;
    att.dataValues["accountBalance"]=accountBalance;
    return att;

  }

}
module.exports=pdf2wordCtl;
