var System=require("../../system");
var settings=require("../../../config/settings");
class patentqueryCtl{
  constructor(){
    this.GsbPatentSearchApi=System.getObject("api.gsbpatentsearch");
  }
  convertDate(time){
     if(time==null){
       return "";
     }
     var date =  new Date(Number(time*1000));
     var y = 1900+date.getYear();
     var m = "0"+(date.getMonth()+1);
     var d = "0"+date.getDate();
     return y+"-"+m.substring(m.length-2,m.length)+"-"+d.substring(d.length-2,d.length);
  }

  async findsenior(queryobj,obj,req){//高级检索
    var appkey=req.session.app.appid;
    var result={rows:[],code_counts:[],count:0};
    var sources=[];
    var codes=[];
    var fmtype = obj.fmtype==null?"":obj.fmtype;
    var xxtype = obj.xxtype==null?"":obj.xxtype;
    var wgtype = obj.wgtype==null?"":obj.wgtype;
    var grtype = obj.grtype==null?"":obj.grtype;
    var yxstatus = obj.yxstatus==null?"":obj.yxstatus;
    var szstatus = obj.szstatus==null?"":obj.szstatus;
    var wxstatus = obj.wxstatus==null?"":obj.wxstatus;
    var filingname = obj.filingname==null?"":obj.filingname;
    var pubno = obj.pubno==null?"":obj.pubno;
    var abstract = obj.abstract==null?"":obj.abstract;
    var grno = obj.grno==null?"":obj.grno;
    var priorno = obj.priorno==null?"":obj.priorno;
    var ipcno = obj.ipcno==null?"":obj.ipcno;
    var applname = obj.applname==null?"":obj.applname;
    var filingdate1 = obj.filingdate1==null?"":obj.filingdate1;
    var filingdate2 = obj.filingdate2==null?"":obj.filingdate2;
    var invname = obj.invname==null?"":obj.invname;
    var pubdate1 = obj.pubdate1==null?"":obj.pubdate1;
    var pubdate2 = obj.pubdate2==null?"":obj.pubdate2;
    var filingno = obj.filingno==null?"":obj.filingno;
    var grdate1 = obj.grdate1==null?"":obj.grdate1;
    var grdate2 = obj.grdate2==null?"":obj.grdate2;
    var pageSize=obj.pageSize;
    var currentPage=obj.currentPage;

    var data={
      appKey:appkey,
      fmtype:fmtype,
      xxtype:xxtype,
      wgtype:wgtype,
      grtype:grtype,
      yxstatus:yxstatus,
      szstatus:szstatus,
      wxstatus:wxstatus,
      filingname:filingname,
      pubno:pubno,
      abstract:abstract,
      grno:grno,
      priorno:priorno,
      ipcno:ipcno,
      applname:applname,
      filingdate1:filingdate1,
      filingdate2:filingdate2,
      invname:invname,
      pubdate1:pubdate1,
      pubdate2:pubdate2,
      filingno:filingno,
      grdate1:grdate1,
      grdate2:grdate2,
      pagesize:pageSize,
      page:currentPage
    };
    var tms =await this.GsbPatentSearchApi.seniorSearch(data);//获取查询结果
    var that=this;
    if(tms.status == 0){
      result.count=tms.data.total;
      tms.data.hits.forEach(function(pa){
        var source={
             filingno:pa._source.filing_no,
             pubtype:pa._source.pub_type,
             filingdate:that.convertDate(pa._source.filing_date),
             pubdate:that.convertDate(pa._source.pub_date),
             pubno:pa._source.pub_no,
             grdate:that.convertDate(pa._source.gr_date),
             grno:pa._source.gr_no,
             applname:pa._source.applicant_name,
             invname:pa._source.inventor_name,
             agentname1:pa._source.agent_name1,
             agentname2:pa._source.agent_name2,
             agencycode:pa._source.agency_code,
             agencyname:pa._source.agency_name,
             countrycode:pa._source.country_code,
             applzip:pa._source.appl_zip,
             appladdress:pa._source.appl_address,
             filingname:pa._source.filing_name,
             pubstatus:pa._source.pub_status,
             pubstatusnow:pa._source.pub_status_now,
             abstract:pa._source.abstr_text,
             mainipc:pa._source.main_ipc,
             ipcversion:pa._source.ipc_version,
             otheripc:pa._source.other_ipc,
             priorinfo:pa._source.prior_info,
             pctinfo:pa._source.pct_info
        };
        sources.push(source);
      });
      result.rows=sources;
    }
    return System.getResult2(result,null);
  }

  async findintellect(queryobj,obj,req){//智能检索
    var appkey=req.session.app.appid;
    var result={rows:[],code_counts:[],count:0};
    var sources=[];
    var codes=[];
    var selectName=obj.selectName==null?"":obj.selectName;
    var pageSize=obj.pageSize;
    var currentPage=obj.currentPage;
    var data={
      appKey:appkey,
      selectName:selectName,
      pagesize:pageSize,
      page:currentPage
    };
    var tms =await this.GsbPatentSearchApi.intellectSearch(data);//获取查询结果
    var that=this;
    if(tms.status == 0){
      result.count=tms.data.total;
      console.log(tms);
      tms.data.hits.forEach(function(pa){
        console.log(pa);
        var source={
             filingno:pa._source.filing_no,
             pubtype:pa._source.pub_type,
             filingdate:that.convertDate(pa._source.filing_date),
             pubdate:that.convertDate(pa._source.pub_date),
             pubno:pa._source.pub_no,
             grdate:that.convertDate(pa._source.gr_date),
             grno:pa._source.gr_no,
             applname:pa._source.applicant_name,
             invname:pa._source.inventor_name,
             agentname1:pa._source.agent_name1,
             agentname2:pa._source.agent_name2,
             agencycode:pa._source.agency_code,
             agencyname:pa._source.agency_name,
             countrycode:pa._source.country_code,
             applzip:pa._source.appl_zip,
             appladdress:pa._source.appl_address,
             filingname:pa._source.filing_name,
             pubstatus:pa._source.pub_status,
             pubstatusnow:pa._source.pub_status_now,
             abstract:pa._source.abstr_text,
             mainipc:pa._source.main_ipc,
             ipcversion:pa._source.ipc_version,
             otheripc:pa._source.other_ipc,
             priorinfo:pa._source.prior_info,
             pctinfo:pa._source.pct_info
        };
        sources.push(source);
      });
      result.rows=sources;
    }
    return System.getResult2(result,null);
  }
}
module.exports=patentqueryCtl;
