var System=require("../../system");
var settings=require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
class PatentinfoCtl extends CtlBase{
  constructor(){
    super(CtlBase.getServiceName(PatentinfoCtl));
  }
  async initNewInstance(queryobj,req){
    return system.getResult2({},null);
  }
  async createOrEdit(queryobj,qobj,req){
    try {
      console.log(qobj);
      console.log("---------------------------------");
      console.log(req.session.user);
      var patent=null;
      if(qobj.id){
        patent = await this.service.findById(qobj.id);
      }
      console.log(patent);
      if(patent){//修改
        console.log("edit++++++++++++++++++++++++++++++++++++");
        delete qobj.patentsTypeName;
        delete qobj.applierTypeName;
        delete qobj.statusProgressName;
        qobj.applicantRequireType=qobj.applicantRequireType.join(',');
        var result = await this.service.update(qobj);
        return {code:1,data:qobj};
      }else{//新增
        console.log("new++++++++++++++++++++++++++++++++++++");
        if(req && req.session && req.session.app){
          qobj.app_id=req.session.app.id;
        }
        var en=qobj.applicantRequireType.join(',');
        var obj={
          app_id:qobj.app_id,user_id:req.session.user.id,onlyCode:req.session.user.onlyCode,userName:req.session.user.userName,nickName:req.session.user.nickName,
          status:1,statusProgress:"AWAITCHECK",orderNum:"",patentsName:qobj.patentsName,patentsType:qobj.patentsType,applicantRequireType:en,
          applierType:qobj.applierType,applyName:qobj.applyName,applyAddr:qobj.applyAddr,mobile:qobj.mobile,customerContact:qobj.customerContact,customerMobile:qobj.customerMobile,
          wgqPic:qobj.wgqPic,wghPic:qobj.wghPic,wgzPic:qobj.wgzPic,wgyPic:qobj.wgyPic,wgfstPic:qobj.wgfstPic,wgystPic:qobj.wgystPic,wgltPic:qobj.wgltPic,
          zipFile:qobj.zipFile,registrationFormUrl:qobj.registrationFormUrl,technicalFileUrl:qobj.technicalFileUrl
        }
        console.log("--------------------------obj---------------");
        console.log(obj);
        var rd=await this.service.create(obj);
        return {code:1,data:rd};
      }
    } catch (e) {
      console.log("-----------------------------e");
      console.log(e);
      return {code:-1}
    }
  }
  async hookOrder(qobj,obj){
    console.log(obj);
    var result=await this.service.hookOrder(obj);
    return System.getResult2(result,null);
  }
  async copy(obj,req){
    var user=req.session.user;
    var id=obj.id;
    var form=await this.service.findById(id);
    form=form.dataValues;
    form.id="";
    form.created_at=null;
    form.updated_at=null;
    if(req && req.session && req.session.app){
      form.app_id=req.session.app.id;
      form["user_id"]=req.session.user.id;
    }
    form.orderNum="";
    form.status="1";
    form.statusName="未关联订单";
    form.statusProgress="AWAITCHECK";
    form.statusProgressName="未提交";
    form["createAuthorizeStuff"]="";

    var rd=await this.service.create(form);
    return System.getResult2(rd,null);
  }
  async changeStatus(qobj,obj){
    try {
      var r = await this.service.changeStatus(obj);
      return r;
    } catch (e) {
      return {code:-1}
    }
  }
}
module.exports=PatentinfoCtl;
