var System=require("../../system");
var settings=require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
class ncloneCtl{
  constructor(){
    this.gsbSearchApi=System.getObject("api.gsbtmsearch");
  }
  async getNcl(queryobj,req){
    var that=this;
    var appkey=req.session.app.appid;
    var result={rows:[],count:0};
    var sources=[];
    var nclcode=queryobj.nclcode;
    var data={
      nclcode:nclcode,
      appKey:appkey,
    };
    var ncls = await this.gsbSearchApi.getNcl(data);
    var noCodeList = [];
    if (ncls.status == 0) {
      result.count = ncls.total;
      var d = ncls.data;
      for (var i = 0; i < d.length; i++) {
        var c = d[i];
        var source = { code: "", name: "", fullname: "", pcode: "", disabled: false };
        source.code = c.code;
        source.pcode = c.pid;
        source.name = c.name;
        source.fullname = !c.code || c.code == "undefined" ? c.name : (c.code + " " + c.name);
        if (c.level == 1) {
          source.type = 1;
        }
        if (!c.code || c.code == "undefined") {
          noCodeList.push(source);
        } else {
          sources.push(source);
        }
      }
      for (let index = 0; index < noCodeList.length; index++) {
        const element = noCodeList[index];
        if (element) {
          sources.push(element);
        }
      }
      result.rows = sources;
    }
    return System.getResult2(result, null);
  }

}
module.exports=ncloneCtl;
