var system = require("../../system")
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
class MetaCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(MetaCtl));
    this.productS = system.getObject("service.productSve");
    this.productC = system.getObject("web.productCtl");
    this.userS = system.getObject("service.userSve");
    this.authS = system.getObject("service.authSve");
  }
  //权限 角色+资源节点code+权限字符串,codepath--
  async getUiConfig(queryObj, req) {
    var bizCode = queryObj.biz;
    var cfg = await this.service.getUiConfig(settings.wxconfig.appId);
    console.log(cfg);
    var tmpRoleAuthStr = "";
    if (req && req.session && req.session.user) {
      var tmpRoles = [];
      req.session.user.Roles.forEach(r => {
        tmpRoles.push(r.code);
      });
      //按照角色获取权限列表
      var auths = await this.authS.findAuthsByRole(tmpRoles);
      var codeauthattrs = auths.map(r => {
        if (r.authstrs && r.authstrs != "") {
          return r.authstrs;
        } else {
          return "";
        }
      });
      tmpRoleAuthStr = codeauthattrs.join(",");
    }
    //获取当前登录人的角色，进而获取权限，进而合并工具栏目
    var toolbar = [];

    const bizConfigData = cfg.config["bizs"][bizCode];
    console.log(bizCode);
    Object.keys(bizConfigData.config.auth).map(k => {
      //只要有权限就添加
      if(queryObj.biz=="allfqtm"){
        toolbar=toolbar.concat(bizConfigData.config.auth[k]);
       }else if (req.session.user.account.isSuper || req.session.user.isAdmin) {
        toolbar = toolbar.concat(bizConfigData.config.auth[k]);
      } else {
        if (tmpRoleAuthStr.indexOf(k) >= 0) {
          toolbar = toolbar.concat(bizConfigData.config.auth[k]);
        }
      }
    })
    bizConfigData.config.toolbar = toolbar;
    return system.getResult2(bizConfigData.config, null);
  }
  //  async getCacheQuery(bizCode){
  //    var bizCode=queryObj.biz;
  //    var cfg=await this.service.getUiConfig(settings.wxconfig.appId);
  //    console.log(cfg);
  //    //获取当前登录人的角色，进而获取权限，进而合并工具栏目
  //    var toolbar=[];
  //    const bizConfigData= cfg.config["bizs"][bizCode];
  //    Object.keys(bizConfigData.config.auth).map(k=>{
  //      //只要有权限就添加
  //      toolbar=toolbar.concat(bizConfigData.config.auth[k]);
  //    })
  //    bizConfigData.config.toolbar=toolbar;
  //    return system.getResult2(bizConfigData.config,null);
  //  }
  async getDicConfig(queryObj) {
    try {
      var dicKey = queryObj["dicKey"];
      var cfg = await this.service.getUiConfig(settings.wxconfig.appId);
      //获取当前登录人的角色，进而获取权限，进而合并工具栏目
      var result = cfg.config["pdict"][dicKey];
      return system.getResult2(result, null);
    } catch (e) {
      console.log(e.stack, "error............getDicConfig")
    }
  }
  //每个角色有一个code/codepath的集合
  //只要当前code出现在codepath中，就返回
  //针对叶子节点授权，那么父节点出现在codepath中，所以可以实现父节点返回
  async getRsConfig(q, req) {
    var rs2 = [];
    console.log("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
    var cfg = await this.service.getUiConfig(settings.wxconfig.appId);
    console.log("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy");
    var tmpRoleCodepathStr = "";
    if (req && req.session && req.session.user) {
      //按照用户查询角色
      // try{
      //   var user= await this.userS.getAuths(req.session.user.id);
      //   var roles=await user.getRoles({raw:true});
      //   console.log(roles);
      // }catch(e){
      //   console.log(e);
      // }
      var tmpRoles = [];
      req.session.user.Roles.forEach(r => {
        tmpRoles.push(r.code);
      });
      //按照角色获取权限列表
      var auths = await this.authS.findAuthsByRole(tmpRoles);
      var codepathattrs = auths.map(r => {
        if (r.authstrs && r.authstrs != "") {
          return r.codepath;
        } else {
          return "";
        }
      });
      tmpRoleCodepathStr = codepathattrs.join(",");
    }
    console.log(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>获取当前登录人的角色，进而获取权限，进而合并工具栏目>>>>>>>>>>>>.getRsConfig");
    //获取当前登录人的角色，进而获取权限，进而合并工具栏目
    console.log(tmpRoleCodepathStr);
    console.log(req.session.user);
    for (var i = 0; i < cfg.config["rstree"].children.length; i++) {
      var r = cfg.config["rstree"].children[i];
      var funcrange = function (n) {
        if (req && req.session && req.session.user) {
          if ((req.session.user.account && req.session.user.account.isSuper) || (req.session.user.isAdmin)) {
            n.hidden = false;
          } else {
            if (tmpRoleCodepathStr.indexOf(n.code) < 0) {
              if (n.isctl && n.isctl == "no") {
                n.hidden = false;
              } else {
                n.hidden = true;
                return;
              }
            } else {
              n.hidden = false;
            }

          }
        }
        if (n.children) {
          n.children.forEach((dd) => {
            return funcrange(dd);
          });
        } else {
          if (n.isctl && n.isctl == "no") {
            n.hidden = false;
          }
          return;
        }
      };
      funcrange(r);
    }
    console.log("===================================");
    console.log(cfg.config["rstree"]);
    console.log("===================================");
    return system.getResult2(cfg.config["rstree"], null);
  }
  async getRouteConfig() {
    var cfg = await this.service.getUiConfig(settings.wxconfig.appId);
    //获取当前登录人的角色，进而获取权限，进而合并工具栏目
    var tmp = {};
    tmp.bizs = cfg.config["bizs"];
    var products = await this.productS.list(settings.wxconfig.appId);
    tmp.ps = await this.productC.addVisitCountData(products);
    return system.getResult2(tmp, null);
  }
}
module.exports = MetaCtl;
