var system=require("../../system")
var settings=require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
class LbsCtl extends CtlBase{
   constructor(){
     super(CtlBase.getServiceName(LbsCtl));
     //this.appS=system.getObject("service.appSve");
   }
   async addressSearch(gobj,pobj,req){
     console.log("--------------------------------------------------------------");
     console.log(pobj);
     var address=pobj.address==null?"":pobj.address;
     if(address==""){
         return system.getResult2(null,null);
     }
     var distance=pobj.distance==null?"":pobj.distance;
     if(distance==""){
         return system.getResult2(null,null);
     }
     address=await this.getConvertSemiangleStr(address);//全半角转化
     var params = {
         "appkey":"d41d8cd98f00b204e9800998ecf8427e",
         "address":address,
         "distance":distance,
         "pagesize":pobj.pageSize,
         "currentPage":pobj.currentPage
     }
     var reqUrl="http://43.247.184.92:8880/lbs/api/addresssearch";
     var rtn=null;
     var rc=system.getObject("util.execClient");
     try{
         rtn=await rc.execPost(params,reqUrl);
         var tmpResult=JSON.parse(rtn.stdout);
         console.log("------------------------------------");
         console.log(tmpResult);
         if(tmpResult.status!=0){
             return system.getResult2(null,null,"other method fail");
         }else{

             return tmpResult}
     }catch(e){
         return system.getResult2(null,null,"zntjSearch error;");
     }

   }
   async lalSearch(gobj,pobj,req){
    console.log("--------------------------------------------------------------");
    console.log(pobj);
    var lat=pobj.lat==null?"":pobj.lat;
    if(lat==""){
        return system.getResult2(null,null);
    }
    var lng=pobj.lng==null?"":pobj.lng;
    if(lng==""){
        return system.getResult2(null,null);
    }
    var distance=pobj.distance==null?"":pobj.distance;
    if(distance==""){
        return system.getResult2(null,null);
    }
    var params = {
        "appkey": "d41d8cd98f00b204e9800998ecf8427e",
        "lat":lat,
        "lng":lng,
        "distance":distance,
        "pagesize":pobj.pageSize,
        "currentPage":pobj.currentPage
    };
    var reqUrl="http://43.247.184.92:8889/lbs/api/lalsearch";
    var rtn=null;
    var rc=system.getObject("util.execClient");
    try{
        rtn=await rc.execPost(params,reqUrl);
        var tmpResult=JSON.parse(rtn.stdout);
        console.log("------------------------------------");
        console.log(tmpResult);
        if(tmpResult.status!=0){
            return system.getResult2(null,null,"other method fail");
        }else{
            return tmpResult
          }
    }catch(e){
        return system.getResult2(null,null,"zntjSearch error;");
    }

  }
  async citySearch(gobj,pobj,req){
    console.log("--------------------------------------------------------------");
    console.log(pobj);
    var cityName=pobj.cityName==null?"":pobj.cityName;
    if(cityName==""){
        return system.getResult2(null,null);
    }
    cityName=await this.getConvertSemiangleStr(cityName);//全半角转化
    var params = {
        "appkey":"d41d8cd98f00b204e9800998ecf8427e",
        "cityName":cityName,
        "pagesize":pobj.pageSize,
        "currentPage":pobj.currentPage
    }
    var reqUrl="http://43.247.184.92:8886/lbs/api/citysearch";
    var rtn=null;
    var rc=system.getObject("util.execClient");
    try{

        rtn=await rc.execPost(params,reqUrl);
        var tmpResult=JSON.parse(rtn.stdout);
        console.log("------------------------------------");
        console.log(tmpResult);
        if(tmpResult.status!=0){
            return system.getResult2(null,null,"other method fail");
        }else{

            return tmpResult}
    }catch(e){
        return system.getResult2(null,null,"zntjSearch error;");
    }

  }

  async getConvertSemiangleStr(str){
      var result = "";
      var len = str.length;
      for(var i=0;i<len;i++)
      {
          var cCode = str.charCodeAt(i);
          //全角与半角相差（除空格外）：65248（十进制）
          cCode = (cCode>=0xFF01 && cCode<=0xFF5E)?(cCode - 65248) : cCode;
          //处理空格
          cCode = (cCode==0x03000)?0x0020:cCode;
          result += String.fromCharCode(cCode);
      }
      return result;
  };


}
module.exports=LbsCtl;
