var system=require("../../system")
var settings=require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
class InvoiceCtl extends CtlBase{
   constructor(){
     super(CtlBase.getServiceName(InvoiceCtl));
     //this.appS=system.getObject("service.appSve");
     this.orderS=system.getObject("service.orderSve");
     this.calculatepriceS=system.getObject("service.calculatepriceSve");
   }

   async initNewInstance(queryobj,qobj){
     return system.getResult2(rd,null);
   }

   async getInfoByOrderNum(pobj,obj){
     var reqParams={
         orderNum:obj.orderNum
     };
     var invoiceinfo=await this.service.findOne(reqParams);
     if( invoiceinfo == null )
     {
       var calculatepriceinfo=await this.calculatepriceS.findOne(reqParams);
       var orderinfo= await this.orderS.findOneByOrderNum(obj.orderNum);
       invoiceinfo={"mobile":"","email":"","invoiceHeadUp":"","totalSum":""};
       invoiceinfo.totalSum=orderinfo.totalSum;
       invoiceinfo.mobile=calculatepriceinfo.mobile;
       invoiceinfo.email=calculatepriceinfo.email;
       invoiceinfo.invoiceHeadUp=orderinfo.applyName;
     }
     return invoiceinfo;
   }

   async showInvoiceHeadUp(pobj,obj){
     var reqParams={
         orderNum:obj.orderNum
     };
     var orderinfo= await this.orderS.findOneByOrderNum(pobj.orderNum);
     return orderinfo;
   }

   async addInvoiceInfo(gobj,pobj,req){//发票申请
         var user=req.session.user;
         if(user==null){
           return {code:-1,msg:"用户信息为空"}
         }
         if(pobj==null||pobj.invoiceInfo==null){
           return {code:-1,msg:"请求信息为空"}
         }
         if(pobj.invoiceInfo.invoiceHeadUpType==null||pobj.invoiceInfo.invoiceHeadUpType==""){
           return {code:-1,msg:"请求信息类型为空"}
         }
          var orderinfo= await this.orderS.findOneByOrderNum(pobj.orderNum);
          if( orderinfo ==null )
          {
            return {code:-1,msg:"数据操作失败"}
          }
          var result= await this.service.createOrUpdateInvoiceInfo(user,orderinfo,pobj);
          if(result==null){
            return {code:-1,msg:"数据操作失败"}
          }
          return {code:"1",msg:"ok"};
      }

}
module.exports=InvoiceCtl;
