var system=require("../../system")
var settings=require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
class FiledownloadCtl extends CtlBase{
   constructor(){
     super(CtlBase.getServiceName(FiledownloadCtl));
     this.excelClient = system.getObject("util.excelClient");
   }

   async download(queryobj,qobj,req){
     let id = qobj.code;
     var rows = qobj.rows || [];
     var userId = req.session.user.id;
     var fileName = qobj.fileName || "";

     var code = uuidv4();
     if(fileName){
       fileName = fileName + ".xlsx";
     } else {
       fileName = "data_" + userId + "_" + new Date().getTime() + ".xlsx";
     }

     var param = {
       title: "商标查询结果列表",
       code : code,
       fileName : fileName,
       user : req.session.user,
       rows : rows
     }

     this.excelClient.download(param);

     return system.getResult2(code);
   }
}
module.exports=FiledownloadCtl;
