var system = require("../../system")
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
class DrafthistoryCtl extends CtlBase {

    constructor() {
        let name = CtlBase.getServiceName(DrafthistoryCtl);
        console.log('--ctl print:', name);
        super(name);
    }

    //post
    async createDraft(q, body, req) {
        try{
            body.userId = req.session.user.id;
            console.log('create draft========', body);
            let result = await this.service.createOne(body);
            return system.getResult2(result, req);
        }catch(e) {
            return system.getErrResult2(e);
        }
        
    }

    //get
    async deleteDraft(obj, req) {
        try {
            obj.userId = req.session.user.id;
            console.log('delete draft========', obj);
            let result = await this.service.deleteByObj(obj);
            return system.getResult2(result, req);
        } catch (e) {
            return system.getErrResult2(e);
        }
    }

    //post
    async updateDraft(q, body, req) {
        try {
            console.log('updata draft=========: ', body);
            body.obj.userId = req.session.user.id;
            let result = await this.service.updateByObj(body.obj, body.newData);
            return system.getResult2(result, req);
        } catch (e) {
            return system.getErrResult2(e);
        }
    }

    //get 前端需要创建两个接口，一个是获取所有，一个是按名称索引所有
    //查询当前用户所有草稿版本例：obj = {'userId': '333'}
    //查询当前用户的某个名字草稿版本例：obj = {'userId': '333', 'draftName': '测试2'}
    async findDraft(obj, req) {
        try {
            obj.userId = req.session.user.id;
            let result = await this.service.findByObj(obj);
            return system.getResult2(result, req);
        } catch (e) {
            return system.getErrResult2(e);
        }

    }

    async findOneDraft(obj, req) {
        try {
            obj.userId = req.session.user.id;
            let result = await this.service.findOneById(obj);
            return system.getResult2(result, req);
        } catch (e) {
            return system.getErrResult2(e);
        }

    }

}
module.exports = DrafthistoryCtl;