var System=require("../../system");
var settings=require("../../../config/settings");
var pinyin = require("pinyin");
class bytmqueryCtl{
  constructor(){
    this.GsbByTmSearchApi=System.getObject("api.bytmsearch");
    this.testApi=System.getObject("api.testApi");
    this.utilstmSve=System.getObject("service.utilstmSve");
    this.utilscontent=System.getObject("service.utilscontentfilterSve");
    this.tm_type={P:"普通商标",J:"集体商标",Z:"证明商标",T:"特殊商标"};
    this.tm_status={1:"申请中",2:"已初审",3:"已注册",4:"已无效",5:"其他"};
    this.imageQueryUrl=settings.apiconfig.imageQueryUrl();
    this.tm_gjfl={1:"01类 化学原料",2:"02类 颜料油漆",3:"03类 日化用品",4:"04类 燃料油脂",5:"05类 医药",6:"06类 金属材料",7:"07类 机械设备",8:"08类 手工器械",9:"09类 科学仪器",
                  10:"10类 医疗器械",11:"11类 灯具空调",12:"12类 运输工具",13:"13类 军火烟火",14:"14类 珠宝钟表",15:"15类 乐器",16:"16类 办公用品",17:"17类 橡胶制品",18:"18类 皮革皮具",19:"19类 建筑材料",20:"20类 家具",21:"21类 厨房洁具",22:"22类 绳网袋蓬",23:"23类 纱线丝",24:"24类 布料床单",
                  25:"25类 服装鞋帽",26:"26类 钮扣拉链",27:"27类 地毯席垫",28:"28类 健身器材",29:"29类 食品",30:"30类 方便食品",31:"31类 农林生鲜",32:"32类 啤酒饮料",33:"33类 酒",34:"34类 烟草烟具",35:"35类 广告销售",36:"36类 金融物管",37:"37类 建筑修理",38:"38类 通讯服务",
                  39:"39类 运输贮藏",40:"40类 材料加工",41:"41类 教育娱乐",42:"42类 科技服务",43:"43类 餐饮住宿",44:"44类 医疗园艺",45:"45类 社会服务"};
  }
  convertDate(time){
     if(time==null){
       return "";
     }
     var date =  new Date(Number(time*1000));
     var y = 1900+date.getYear();
     var m = "0"+(date.getMonth()+1);
     var d = "0"+date.getDate();
     return y+"-"+m.substring(m.length-2,m.length)+"-"+d.substring(d.length-2,d.length);
  }

  async getSbqz(data){
    var tms=await this.utilstmSve.getGroupNclNumList(data);
    var that=this;
    var sbqz="";
    if(tms.status == 0&&tms.data.exist.length>0){
      tms.data.exist.forEach(function(c){
        sbqz+=c.code+";";
      });
    }
    return sbqz;
  }

  async findTrademarkNameIndex(query,obj){//根据商标名称模糊查询,首次查询,
    console.log("----------------------");
    console.log(obj);
    var result={rows:[],code_counts:[],count:0};
    var sources=[];
    var codes=[];
    var tmName=obj.tmName==null?"":obj.tmName;
    tmName=tmName.replace(/[&\|\\\*^%$#@\-]/g,"");
    var pageSize=obj.pageSize;
    var currentPage=obj.currentPage;
    var ncl=obj.ncl;
    var nclcode=[];
    for(var i=0;i<ncl.length;i++){
      console.log(ncl[i]);
      var num = Number(ncl[i].slice(0,2))
      console.log(num);
      nclcode.push(num);
    }
    var data={
      tmName:tmName,
      nclcode:nclcode,
      pagesize:pageSize,
      page:currentPage
    };
    var tms =await this.GsbByTmSearchApi.tmNmaeSearchByNcl(data);//获取查询结果
    var tmsjuhe = await this.GsbByTmSearchApi.tmNmaeSearchByNcljuhe(data);//获取聚合结果
    var that=this;
    if(tms.status == 0){
      result.count=tms.total;
      tms.data.forEach(function(tm){
        var source={
             sbmc:tm.tm_name,//商标名称
             sbpy:tm.tm_name_py,//商标拼音
             sbyw:tm.tm_name_en,//商标英文
             gjfl:tm.ncl_one_codes,//国际分类
             gjflname:that.tm_gjfl[tm.ncl_one_codes],//国际分类名称
             sbzch:tm.tm_regist_num,//商标注册号
             sblx:that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
             sbzt:that.tm_status[tm.status],//商标状态
             sqrq:that.convertDate(tm.apply_day),//申请日期
             csrq:that.convertDate(tm.first_notice_day),//初审日期
             zcrq:that.convertDate(tm.original_regist_notice_day),//注册日期
             csggym:tm.first_notice_page_num,//初审公告页码
             zcr:tm.applicant_cn,//申请人
             jzrq:that.convertDate(tm.tm_end_day) ,//截止日期
             csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
             zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
             csgg:tm.first_notice_issue,//初审公告（期号）
             zcgg:tm.regist_notice_issue,//注册公告
             zcggym:tm.regist_notice_page_num,//注册公告页码
             yzcr:tm.original_applicant_cn,//原申请人
             zcdz:tm.applicant_cn_addr,//申请地址
             zcren:tm.applicant_en,//申请人enlish
             zcdzen:tm.applicant_en_addr,//申请地址enlish
             dljg:tm.tm_agency,//代理机构
             zxzt:"",//最新状态
             spfwxm:"",
             lcxx:"",
             logo:tm.pic_url,//商标图样
        };
        sources.push(source);

      });
      result.rows=sources;
    };
    if(tmsjuhe.status==0){
      tmsjuhe.buckets.sort(function(a,b){
        return a.key - b.key;
      });
      tmsjuhe.buckets.forEach(function(buck){
            var name = that.tm_gjfl[buck.key];
            var gjfl ={//国际分类
            	"key":buck.key,
            	"keyvalue":name,
            	"keycount":buck.doc_count,
            };
            codes.push(gjfl);
      });
      result.code_counts=codes;
    }
    return System.getResult2(result,null);
  }

  async findTrademarkName(query,obj){//根据商标名称模糊查询
    console.log("--------------------------------------");
    console.log(obj);
    var result={rows:[],code_counts:[],status_counts:[],no_code_counts:[],year_counts:[],count:0};
    var sources=[];
    var codes=[];
    var no_code=[];
    var year_count=[]
    var flztstatus=[];
    var tmName=obj.tmName==null?"":obj.tmName;
    tmName=tmName.replace(/[&\|\\\*^%$#@\-]/g,"");
    console.log("ttttttttttttttttttttttttttttttttttttttttttttttt");
    console.log(tmName);
    var sqlbtabkey = obj.sqlbtabkey==null?"":obj.sqlbtabkey;
    var flzttabkey=obj.flzttabkey==null?"":obj.flzttabkey;
    var sqnftabkey=obj.sqnftabkey==null?"":obj.sqnftabkey;
    var pageSize=obj.pageSize;
    var currentPage=obj.currentPage;
    var ncl=obj.ncl;
    var nclcode=[];
    for(var i=0;i<ncl.length;i++){
      console.log(ncl[i]);
      var num = Number(ncl[i].slice(0,2))
      console.log(num);
      nclcode.push(num);
    };
    var nclNum=obj.nclNum;
    var nclNumcode=[];
    for(var i=0;i<nclNum.length;i++){
      var num = Number(nclNum[i])
      nclNumcode.push(num);
    }
    var ncltwocodesearch = obj.xcl;
    var ncltwo =[];
    for(var i=0;i<ncltwocodesearch.length;i++){
      var code=ncltwocodesearch[i].code;
      ncltwo.push(code);
    }
    var js="";
    var bz="";
    var tyc="";
    var py="";
    var xjz="";
    var dx="";
    var tycdata=[];
    var xjzdata=[];
    var contain="";
    //按商标检索条件进行参数---'拼音', '同义词', '形近字', '换序',"左匹配","右匹配"
    var sbtjdata = obj.sbtjdata;
    for (var i = 0; i < sbtjdata.length; i++) {
      var tmp=sbtjdata[i];
      if(tmp=="近似"){
        js="js";
      }if(tmp=="变字"){
        bz="bz";
      }
      if(tmp=="同义词"){
        tyc="tyc";
        var objd={
          name:tmName
        }
        var tms=await this.utilscontent.getSynonymsList(objd);
        console.log("--------------------------------------");
        console.log(tms.data);
        if(tms.code==1){
          tycdata=tms.data;
        }
      }
      if(tmp=="拼音"){
        py="py";
        console.log("pinyin============================");
        console.log(tmName);
        var pynamelist=pinyin(tmName,{
          heteronym: true,
          style: pinyin.STYLE_NORMAL,
        });
        var pp=[];
        console.log(pynamelist);
        pynamelist.forEach(function(c){
          pp.push(c[0]);
        });
        var pyname=pp.join("");
        console.log("pppppppppppppppppppppppppppppppppppppppp");
        console.log(pynamelist);
        console.log(pyname);
      }
      if(tmp=="形近字"){
        xjz="xjz";
        var objd={
          name:tmName
        }
        var tms=await this.utilscontent.getSimilarList(objd);
        console.log("--------------------------------------");
        console.log(tms.data);
        if(tms.code==1){
          xjzdata=tms.data;
        }
      }
      if(tmp=="换序"){
        dx="dx";
      }
      if(tmp=="包含该商标"){
        contain="contain";
      }
    }
    var data={
      tmName:tmName,
      sqlbtabkey:sqlbtabkey,
      flzttabkey:flzttabkey,
      sqnftabkey:sqnftabkey,
      pagesize:pageSize,
      page:currentPage,
      nclcode:nclcode,
      nclNumcode:nclNumcode,
      js:js,
      bz:bz,
      tyc:tyc,
      tycdata:tycdata,
      py:py,
      pyname:pyname,
      xjz:xjz,
      xjzdata:xjzdata,
      dx:dx,
      contain:contain,
      ncltwo:ncltwo
    };
    var tms =await this.GsbByTmSearchApi.tmNameSearch(data);//获取查询结果
    // console.log(tms);
    var tmsjuhe = await this.GsbByTmSearchApi.tmNamejuheSearch(data);//获取尼斯大类聚合结果
    var tmsjuhestatus = await this.GsbByTmSearchApi.tmNamejuheFlztSearch(data);//根据商标状态聚合
    // console.log(tmsjuhestatus);
    var tmsjuheyear = await this.GsbByTmSearchApi.tmNamejuheYearSearch(data);//根据商标year聚合
    // console.log(tmsjuheyear);
    var that=this;
    if(tms.status == 0){
      result.count=tms.total;
      for (var i = 0; i < tms.data.length; i++) {
        var tm =tms.data[i];
        if(tm!=null){
          // var sbdata={
          //   reg_num:tm.tm_regist_num,
          //   nclone_code:tm.ncl_one_codes
          // };
          // var sbtms= await that.utilstmSve.getGroupNclNumList(sbdata);
          // var sbqz="";
          // if(sbtms.status == 0 && sbtms.data.exist.length>0){
          //   sbtms.data.exist.forEach(function(c){
          //     sbqz+=c.code+";";
          //   });
          // }
          var sbqz="";
          if(tm.ncl_two_codes&&tm.ncl_two_codes.length>0){
            // console.log(tm.ncl_two_codes);
            tm.ncl_two_codes.forEach(function(c){
              if(c){
                sbqz+=c+";";
              }
            });
          }
          var source={
               sbmc:tm.tm_name,//商标名称
               sbpy:tm.tm_name_py,//商标拼音
               sbyw:tm.tm_name_en,//商标英文
               gjfl:tm.ncl_one_codes,//国际分类
               gjflname:that.tm_gjfl[tm.ncl_one_codes],//国际分类名称
               sbzch:tm.tm_regist_num,//商标注册号
               sblx:that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
               sbzt:that.tm_status[tm.status],//商标状态
               sqrq:that.convertDate(tm.apply_day),//申请日期
               csrq:that.convertDate(tm.first_notice_day),//初审日期
               zcrq:that.convertDate(tm.original_regist_notice_day),//注册日期
               csggym:tm.first_notice_page_num,//初审公告页码
               zcr:tm.applicant_cn,//申请人
               jzrq:that.convertDate(tm.tm_end_day) ,//截止日期
               csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
               zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
               csgg:tm.first_notice_issue,//初审公告（期号）
               zcgg:tm.regist_notice_issue,//注册公告
               zcggym:tm.regist_notice_page_num,//注册公告页码
               yzcr:tm.original_applicant_cn,//原申请人
               zcdz:tm.applicant_cn_addr,//申请地址
               zcren:tm.applicant_en,//申请人enlish
               zcdzen:tm.applicant_en_addr,//申请地址enlish
               dljg:tm.tm_agency,//代理机构
               zxzt:"",//最新状态
               spfwxm:"",
               lcxx:"",
               sbqz:sbqz,
               logo:tm.pic_url,//商标图样
          };
          sources.push(source);
        }
      }
      result.rows=sources;
    }
    if(nclNum.length>0&&nclNum.length<45){
      if(tmsjuhe.status==0){
        tmsjuhe.buckets.sort(function(a,b){
          return a.key - b.key;
        });
        tmsjuhe.buckets.forEach(function(buck){
              var name = that.tm_gjfl[buck.key];
              var gjfl ={//国际分类
                "key":buck.key,
                "keyvalue":name,
                "keycount":buck.doc_count,
              };
              codes.push(gjfl);
        });
        result.code_counts=codes;
        result.no_code_counts=no_code;
      }
    }else{
      if(tmsjuhe.status==0){
        tmsjuhe.buckets.sort(function(a,b){
          return a.key - b.key;
        });
        Array.prototype.remove = function(val) {
          var index = this.indexOf(val);
          if (index > -1) {
            this.splice(index, 1);
          }
        };
        var num=[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
           21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45];
        tmsjuhe.buckets.forEach(function(buck){
              var name = that.tm_gjfl[buck.key];
              var gjfl ={//国际分类
              	"key":buck.key,
              	"keyvalue":name,
              	"keycount":buck.doc_count,
              };
              codes.push(gjfl);
              num.remove(Number(buck.key));
        });
        result.code_counts=codes;
        num.forEach(function(n){
          var name = that.tm_gjfl[n];
          var no_gjfl={
            "name":name
          }
          no_code.push(no_gjfl);
        });
        result.no_code_counts=no_code;
      }
    }
    if(tmsjuhestatus.status==0){
      tmsjuhestatus.buckets.sort(function(a,b){
        return a.key - b.key;
      });
      tmsjuhestatus.buckets.forEach(function(buck){
        var name = that.tm_status[buck.key];
        var st={
          "key":buck.key,
          "keyvalue":name,
          "keycount":buck.doc_count,
        };
        flztstatus.push(st);
      });
      result.status_counts=flztstatus;
    }
    if(tmsjuheyear.status==0){
      tmsjuheyear.buckets.sort(function(a,b){
        return b.key - a.key;
      });
      tmsjuheyear.buckets.forEach(function(buck){
        var name = that.tm_status[buck.key];
        var year={
          "key":buck.key,
          "keycount":buck.doc_count,
        };
        year_count.push(year);
      });
      result.year_counts=year_count;
    }
    return System.getResult2(result,null);
  }

  async findTrademarkNameAccurate(query,obj){//通过商标名来进行精准查询
    console.log(obj);
    var result={rows:[],code_counts:[],status_counts:[],no_code_counts:[],year_counts:[],count:0};
    var sources=[];
    var codes=[];
    var no_code=[];
    var year_count=[];
    var flztstatus=[];
    var tmName=obj.tmName==null?"":obj.tmName;
    tmName=tmName.replace(/[&\|\\\*^%$#@\-]/g,"");
    var sqlbtabkey = obj.sqlbtabkey==null?"":obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey==null?"":obj.flzttabkey;
    var sqnftabkey=obj.sqnftabkey==null?"":obj.sqnftabkey;
    var pageSize=obj.pageSize;
    var currentPage=obj.currentPage;
    var ncl=obj.ncl;
    var nclcode=[];
    for(var i=0;i<ncl.length;i++){
      console.log(ncl[i]);
      var num = Number(ncl[i].slice(0,2))
      console.log(num);
      nclcode.push(num);
    };
    var nclNum=obj.nclNum;
    var nclNumcode=[];
    for(var i=0;i<nclNum.length;i++){
      var num = Number(nclNum[i])
      nclNumcode.push(num);
    }

    var ncltwocodesearch = obj.xcl;
    var ncltwo =[];
    console.log("ttttttttttttttttttttttttttttttttttttttttttttttt");
    for(var i=0;i<ncltwocodesearch.length;i++){
      console.log(ncltwocodesearch[i]);
      var code=ncltwocodesearch[i].code;
      ncltwo.push(code);
    }
    console.log(ncltwo);

    var data={
      tmName:tmName,
      sqlbtabkey:sqlbtabkey,
      flzttabkey:flzttabkey,
      sqnftabkey:sqnftabkey,
      nclcode:nclcode,
      nclNumcode:nclNumcode,
      ncltwo:ncltwo,
      pagesize:pageSize,
      page:currentPage
    };
    var tms =await this.GsbByTmSearchApi.tmAccurateSearch(data);//获取查询结果
    // console.log(tms);
    // console.log("++++++++++++++++++++++++++++++++++++++++++++++++");
    var tmsjuhe = await this.GsbByTmSearchApi.tmAccuratejuheSearch(data);//获取尼斯大类聚合结果
    var tmsjuhestatus = await this.GsbByTmSearchApi.tmAccuratejuheFlztSearch(data);//根据商标状态聚合
    var tmsjuheyear = await this.GsbByTmSearchApi.tmAccuratejuheYearSearch(data);//根据商标year聚合
    var that=this;
    if(tms.status == 0){
      result.count=tms.total;
      for (var i = 0; i < tms.data.length; i++) {
        var tm =tms.data[i];
        if(tm!=null){
          // var sbdata={
          //   reg_num:tm.tm_regist_num,
          //   nclone_code:tm.ncl_one_codes
          // };
          // var sbtms= await that.utilstmSve.getGroupNclNumList(sbdata);
          // var sbqz="";
          // if(sbtms.status == 0 && sbtms.data.exist.length>0){
          //   sbtms.data.exist.forEach(function(c){
          //     sbqz+=c.code+";";
          //   });
          // }
          var sbqz="";
          // console.log("----------------------------");
          // console.log(tm.ncl_two_codes);
          if(tm.ncl_two_codes&&tm.ncl_two_codes.length>0){
            tm.ncl_two_codes.forEach(function(c){
              if(c){
                sbqz+=c+";";
              }
            });
          }
          var source={
               sbmc:tm.tm_name,//商标名称
               sbpy:tm.tm_name_py,//商标拼音
               sbyw:tm.tm_name_en,//商标英文
               gjfl:tm.ncl_one_codes,//国际分类
               gjflname:that.tm_gjfl[tm.ncl_one_codes],//国际分类名称
               sbzch:tm.tm_regist_num,//商标注册号
               sblx:that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
               sbzt:that.tm_status[tm.status],//商标状态
               sqrq:that.convertDate(tm.apply_day),//申请日期
               csrq:that.convertDate(tm.first_notice_day),//初审日期
               zcrq:that.convertDate(tm.original_regist_notice_day),//注册日期
               csggym:tm.first_notice_page_num,//初审公告页码
               zcr:tm.applicant_cn,//申请人
               jzrq:that.convertDate(tm.tm_end_day) ,//截止日期
               csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
               zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
               csgg:tm.first_notice_issue,//初审公告（期号）
               zcgg:tm.regist_notice_issue,//注册公告
               zcggym:tm.regist_notice_page_num,//注册公告页码
               yzcr:tm.original_applicant_cn,//原申请人
               zcdz:tm.applicant_cn_addr,//申请地址
               zcren:tm.applicant_en,//申请人enlish
               zcdzen:tm.applicant_en_addr,//申请地址enlish
               dljg:tm.tm_agency,//代理机构
               zxzt:"",//最新状态
               spfwxm:"",
               lcxx:"",
               sbqz:sbqz,
               logo:tm.pic_url,//商标图样
          };
        sources.push(source);
        }
      }
      result.rows=sources;
    }
    if(nclNum.length>0&&nclNum.length<45){
      if(tmsjuhe.status==0){
        tmsjuhe.buckets.sort(function(a,b){
          return a.key - b.key;
        });
        tmsjuhe.buckets.forEach(function(buck){
              var name = that.tm_gjfl[buck.key];
              var gjfl ={//国际分类
                "key":buck.key,
                "keyvalue":name,
                "keycount":buck.doc_count,
              };
              codes.push(gjfl);
        });
        result.code_counts=codes;
        result.no_code_counts=no_code;
      }
    }else{
      if(tmsjuhe.status==0){
        tmsjuhe.buckets.sort(function(a,b){
          return a.key - b.key;
        });
        Array.prototype.remove = function(val) {
          var index = this.indexOf(val);
          if (index > -1) {
            this.splice(index, 1);
          }
        };
        var num=[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
           21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45];
        tmsjuhe.buckets.forEach(function(buck){
              var name = that.tm_gjfl[buck.key];
              var gjfl ={//国际分类
              	"key":buck.key,
              	"keyvalue":name,
              	"keycount":buck.doc_count,
              };
              codes.push(gjfl);
              num.remove(Number(buck.key));
        });
        result.code_counts=codes;
        num.forEach(function(n){
          var name = that.tm_gjfl[n];
          var no_gjfl={
            "name":name
          }
          no_code.push(no_gjfl);
        });
        result.no_code_counts=no_code;
      }
    }
    if(tmsjuhestatus.status==0){
      tmsjuhestatus.buckets.sort(function(a,b){
        return a.key - b.key;
      });
      tmsjuhestatus.buckets.forEach(function(buck){
        var name = that.tm_status[buck.key];
        var st={
          "key":buck.key,
          "keyvalue":name,
          "keycount":buck.doc_count,
        };
        flztstatus.push(st);
      });
      result.status_counts=flztstatus;
    }
    if(tmsjuheyear.status==0){
      tmsjuheyear.buckets.sort(function(a,b){
        return b.key - a.key;
      });
      tmsjuheyear.buckets.forEach(function(buck){
        var year={
          "key":buck.key,
          "keycount":buck.doc_count,
        };
        year_count.push(year);
      });
      result.year_counts=year_count;
    }
    var openId=obj.user.openId
    var redisdata={
      openId:openId,
      mark:tmName
    };
    var rediscache =await this.testApi.redisInsert(redisdata);

    return System.getResult2(result,null);
  }

  async findTrademarkzchAccurate(query,obj){//通过商标号来进行精准查询
    var result={rows:[],code_counts:[],status_counts:[],year_counts:[],count:0};
    var sources=[];
    var codes=[];
    var flztstatus=[];
    var year_count=[];
    var regNum=obj.regNum==null?"":obj.regNum;
    var sqlbtabkey = obj.sqlbtabkey==null?"":obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey==null?"":obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey==null?"":obj.sqnftabkey;
    var pageSize=obj.pageSize;
    var currentPage=obj.currentPage;
    var ncltwocodesearch = obj.xcl;
    var ncltwo =[];
    for(var i=0;i<ncltwocodesearch.length;i++){
      var code=ncltwocodesearch[i].code;
      ncltwo.push(code);
    }
    var data={
      regNum:regNum,
      sqlbtabkey:sqlbtabkey,
      flzttabkey:flzttabkey,
      sqnftabkey:sqnftabkey,
      ncltwo:ncltwo,
      pagesize:pageSize,
      page:currentPage
    };
    var tms =await this.GsbByTmSearchApi.tmzchSearch(data);//获取查询结果
    var tmsjuhe = await this.GsbByTmSearchApi.tmzchjuheSearch(data);//获取尼斯大类聚合结果
    var tmsjuhestatus = await this.GsbByTmSearchApi.tmzchjuheFlztSearch(data);//根据商标状态聚合
    var tmsjuheyear = await this.GsbByTmSearchApi.tmzchjuheYearSearch(data);//根据商标year聚合
    var that=this;
    if(tms.status == 0){
      result.count=tms.total;
      for (var i = 0; i < tms.data.length; i++) {
        var tm =tms.data[i];
        if(tm!=null){
          // var sbdata={
          //   reg_num:tm.tm_regist_num,
          //   nclone_code:tm.ncl_one_codes
          // };
          // var sbtms= await that.utilstmSve.getGroupNclNumList(sbdata);
          // var sbqz="";
          // if(sbtms.status == 0 && sbtms.data.exist.length>0){
          //   sbtms.data.exist.forEach(function(c){
          //     sbqz+=c.code+";";
          //   });
          // }
          var sbqz="";
          if(tm.ncl_two_codes&&tm.ncl_two_codes.length>0){
            console.log(tm.ncl_two_codes);
            tm.ncl_two_codes.forEach(function(c){
              if(c){
                sbqz+=c+";";
              }
            });
          }
          var source={
               sbmc:tm.tm_name,//商标名称
               sbpy:tm.tm_name_py,//商标拼音
               sbyw:tm.tm_name_en,//商标英文
               gjfl:tm.ncl_one_codes,//国际分类
               gjflname:that.tm_gjfl[tm.ncl_one_codes],//国际分类名称
               sbzch:tm.tm_regist_num,//商标注册号
               sblx:that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
               sbzt:that.tm_status[tm.status],//商标状态
               sqrq:that.convertDate(tm.apply_day),//申请日期
               csrq:that.convertDate(tm.first_notice_day),//初审日期
               zcrq:that.convertDate(tm.original_regist_notice_day),//注册日期
               csggym:tm.first_notice_page_num,//初审公告页码
               zcr:tm.applicant_cn,//申请人
               jzrq:that.convertDate(tm.tm_end_day) ,//截止日期
               csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
               zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
               csgg:tm.first_notice_issue,//初审公告（期号）
               zcgg:tm.regist_notice_issue,//注册公告
               zcggym:tm.regist_notice_page_num,//注册公告页码
               yzcr:tm.original_applicant_cn,//原申请人
               zcdz:tm.applicant_cn_addr,//申请地址
               zcren:tm.applicant_en,//申请人enlish
               zcdzen:tm.applicant_en_addr,//申请地址enlish
               dljg:tm.tm_agency,//代理机构
               zxzt:"",//最新状态
               spfwxm:"",
               lcxx:"",
               sbqz:sbqz,
               logo:tm.pic_url,//商标图样
          };
        sources.push(source);
        }
      }
      result.rows=sources;
    }
    if(tmsjuhe.status==0){
      tmsjuhe.buckets.sort(function(a,b){
        return a.key - b.key;
      });
      tmsjuhe.buckets.forEach(function(buck){
            var name = that.tm_gjfl[buck.key];
            var gjfl ={//国际分类
            	"key":buck.key,
            	"keyvalue":name,
            	"keycount":buck.doc_count,
            };
            codes.push(gjfl);
      });
      result.code_counts=codes;
    }
    if(tmsjuhestatus.status==0){
      tmsjuhestatus.buckets.sort(function(a,b){
        return b.key - a.key;
      });
      tmsjuhestatus.buckets.forEach(function(buck){
        var name = that.tm_status[buck.key];
        var st={
          "key":buck.key,
          "keyvalue":name,
          "keycount":buck.doc_count,
        };
        flztstatus.push(st);
      });
      result.status_counts=flztstatus;
    }
    if(tmsjuheyear.status==0){
      tmsjuheyear.buckets.sort(function(a,b){
        return a.key - b.key;
      });
      tmsjuheyear.buckets.forEach(function(buck){
        var year={
          "key":buck.key,
          "keycount":buck.doc_count,
        };
        year_count.push(year);
      });
      result.year_counts=year_count;
    }
    console.log(result);
    return System.getResult2(result,null);
  }

  async findTrademarkzcr(query,obj){//通过注册人模糊查询
    console.log(obj);
    var result={rows:[],code_counts:[],status_counts:[],no_code_counts:[],year_counts:[],count:0};
    var sources=[];
    var codes=[];
    var no_code=[];
    var year_count=[];
    var flztstatus=[];
    var applier=obj.regMan==null?"":obj.regMan;
    applier=applier.replace(/[&\|\\\*^%$#@\-]/g,"");
    var sqlbtabkey = obj.sqlbtabkey==null?"":obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey==null?"":obj.flzttabkey;
    var sqnftabkey=obj.sqnftabkey==null?"":obj.sqnftabkey;
    var pageSize=obj.pageSize;
    var currentPage=obj.currentPage;
    var ncltwocodesearch = obj.xcl;
    var ncltwo =[];
    for(var i=0;i<ncltwocodesearch.length;i++){
      var code=ncltwocodesearch[i].code;
      ncltwo.push(code);
    }
    var data={
      applier:applier,
      sqlbtabkey:sqlbtabkey,
      flzttabkey:flzttabkey,
      sqnftabkey:sqnftabkey,
      ncltwo:ncltwo,
      pagesize:pageSize,
      page:currentPage
    };
    var tms =await this.GsbByTmSearchApi.tmzcrSearch(data);//获取查询结果
    var tmsjuhe = await this.GsbByTmSearchApi.tmzcrjuheSearch(data);//获取尼斯大类聚合结果
    var tmsjuhestatus = await this.GsbByTmSearchApi.tmzcrjuheFlztSearch(data);//根据商标状态聚合
    console.log(tmsjuhestatus);
    var tmsjuheyear = await this.GsbByTmSearchApi.tmzcrjuheYearSearch(data);//根据商标year聚合
    var that=this;
    if(tms.status == 0){
      result.count=tms.total;
      for (var i = 0; i < tms.data.length; i++) {
        var tm =tms.data[i];
        if(tm!=null){
          // var sbdata={
          //   reg_num:tm.tm_regist_num,
          //   nclone_code:tm.ncl_one_codes
          // };
          // var sbtms= await that.utilstmSve.getGroupNclNumList(sbdata);
          // var sbqz="";
          // if(sbtms.status == 0 && sbtms.data.exist.length>0){
          //   sbtms.data.exist.forEach(function(c){
          //     sbqz+=c.code+";";
          //   });
          // }
          var sbqz="";
          if(tm.ncl_two_codes&&tm.ncl_two_codes.length>0){
            console.log(tm.ncl_two_codes);
            tm.ncl_two_codes.forEach(function(c){
              if(c){
                sbqz+=c+";";
              }
            });
          }
          var source={
               sbmc:tm.tm_name,//商标名称
               sbpy:tm.tm_name_py,//商标拼音
               sbyw:tm.tm_name_en,//商标英文
               gjfl:tm.ncl_one_codes,//国际分类
               gjflname:that.tm_gjfl[tm.ncl_one_codes],//国际分类名称
               sbzch:tm.tm_regist_num,//商标注册号
               sblx:that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
               sbzt:that.tm_status[tm.status],//商标状态
               sqrq:that.convertDate(tm.apply_day),//申请日期
               csrq:that.convertDate(tm.first_notice_day),//初审日期
               zcrq:that.convertDate(tm.original_regist_notice_day),//注册日期
               csggym:tm.first_notice_page_num,//初审公告页码
               zcr:tm.applicant_cn,//申请人
               jzrq:that.convertDate(tm.tm_end_day) ,//截止日期
               csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
               zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
               csgg:tm.first_notice_issue,//初审公告（期号）
               zcgg:tm.regist_notice_issue,//注册公告
               zcggym:tm.regist_notice_page_num,//注册公告页码
               yzcr:tm.original_applicant_cn,//原申请人
               zcdz:tm.applicant_cn_addr,//申请地址
               zcren:tm.applicant_en,//申请人enlish
               zcdzen:tm.applicant_en_addr,//申请地址enlish
               dljg:tm.tm_agency,//代理机构
               zxzt:"",//最新状态
               spfwxm:"",
               lcxx:"",
               sbqz:sbqz,
               logo:tm.pic_url,//商标图样
          };
        sources.push(source);
        }
      }
      result.rows=sources;
    }
    if(tmsjuhe.status==0){
      tmsjuhe.buckets.sort(function(a,b){
        return a.key - b.key;
      });
      Array.prototype.remove = function(val) {
        var index = this.indexOf(val);
        if (index > -1) {
          this.splice(index, 1);
        }
      };
      var num=[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
         21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45];
      tmsjuhe.buckets.forEach(function(buck){
            var name = that.tm_gjfl[buck.key];
            var gjfl ={//国际分类
            	"key":buck.key,
            	"keyvalue":name,
            	"keycount":buck.doc_count,
            };
            codes.push(gjfl);
            num.remove(Number(buck.key));
      });
      result.code_counts=codes;
      num.forEach(function(n){
        var name = that.tm_gjfl[n];
        var no_gjfl={
          "name":name
        }
        no_code.push(no_gjfl);
      });
      result.no_code_counts=no_code;
    }
    if(tmsjuhestatus.status==0){
      tmsjuhestatus.buckets.sort(function(a,b){
        return a.key - b.key;
      });
      tmsjuhestatus.buckets.forEach(function(buck){
        var name = that.tm_status[buck.key];
        var st={
          "key":buck.key,
          "keyvalue":name,
          "keycount":buck.doc_count,
        };
        flztstatus.push(st);
      });
      result.status_counts=flztstatus;
    }
    if(tmsjuheyear.status==0){
      tmsjuheyear.buckets.sort(function(a,b){
        return b.key - a.key;
      });
      tmsjuheyear.buckets.forEach(function(buck){
        var year={
          "key":buck.key,
          "keycount":buck.doc_count,
        };
        year_count.push(year);
      });
      result.year_counts=year_count;
    }
    console.log(result);
    return System.getResult2(result,null);
  }

  async imagequery(query,obj){
    console.log("===========================");
    console.log(obj);
    var result={rows:[],code_counts:[],status_counts:[],year_counts:[],count:0};
    var sources=[];
    var codes=[];
    var year_count=[];
    var flztstatus=[];
    var key=settings.apiconfig.imageQueryKey;
    var tmUrl=obj.imageUrl;
    var url=this.imageQueryUrl+"?imageurl="+encodeURIComponent(tmUrl)+"&appkey="+key;
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execGet({},url);
      var data=JSON.parse(rtn.stdout);
      if(data[0].length && data[0].length>0 && data[0]!=undefined){
          var d=data[0];
          result.rows=d;
          var RegistNumsAll=[];
          for(var i=0;i<d.length;i++){
            var regNum=d[i];
            RegistNumsAll.push(regNum.imageid);
          }
          var data={
            tmRegistNumsAll:RegistNumsAll,
          };
          var tmsjuhe = await this.GsbByTmSearchApi.imagesearchjuheNcl(data);//获取ncl聚合结果
          var tmsjuhestatus = await this.GsbByTmSearchApi.imagesearchjuheStatus(data);//根据商标状态聚合
          console.log(tmsjuhestatus);
          var tmsjuheyear = await this.GsbByTmSearchApi.imagesearchjuheYear(data);//根据商标year聚合
          var that=this;
          if(tmsjuhe.status==0){
            tmsjuhe.buckets.sort(function(a,b){
              return a.key - b.key;
            });
            tmsjuhe.buckets.forEach(function(buck){
                  var name = that.tm_gjfl[buck.key];
                  var gjfl ={//国际分类
                  	"key":buck.key,
                  	"keyvalue":name,
                  	"keycount":buck.doc_count,
                  };
                  codes.push(gjfl);
            });
            result.code_counts=codes;
          }
          if(tmsjuhestatus.status==0){
            tmsjuhestatus.buckets.sort(function(a,b){
              return a.key - b.key;
            });
            tmsjuhestatus.buckets.forEach(function(buck){
              var name = that.tm_status[buck.key];
              var st={
                "key":buck.key,
                "keyvalue":name,
                "keycount":buck.doc_count,
              };
              flztstatus.push(st);
            });
            result.status_counts=flztstatus;
          }
          if(tmsjuheyear.status==0){
            tmsjuheyear.buckets.sort(function(a,b){
              return b.key - a.key;
            });
            tmsjuheyear.buckets.forEach(function(buck){
              var year={
                "key":buck.key,
                "keycount":buck.doc_count,
              };
              year_count.push(year);
            });
            result.year_counts=year_count;
          }
          result.count=d.length;
          return System.getResult2(result,null);
      }
      return System.getResult2(result,null);
    }catch(e){
      console.log(e);
      return System.getResult2(result,null);
    }
    return System.getResult2(result,null);
  }
  async findImageSearch(query,obj){ //图像检索查询，
    var result={rows:[],code_counts:[],status_counts:[],year_counts:[],count:0};
    var sources=[];
    var codes=[];
    var year_count=[];
    var flztstatus=[];
    var cp = obj.pageInfo.pageNo;
    var ps = obj.pageInfo.pageSize;
    var sqlbtabkey = obj.sqlbtabkey==null?"":obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey==null?"":obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey==null?"":obj.sqnftabkey;
    var tmRegistNumsAll = obj.tmRegistNumsAll==null?"":obj.tmRegistNumsAll;
    var RegistNumsAll=[];
    for(var i=0;i<tmRegistNumsAll.length;i++){
      var regNum=tmRegistNumsAll[i];
      RegistNumsAll.push(regNum.imageid);
    }
    var from = Number((cp-1)*ps);
    var end=Number(from+ps);
    var tmRegistNums=RegistNumsAll.slice(from,end);
    var ncltwocodesearch = obj.xcl;
    var ncltwo =[];
    for(var i=0;i<ncltwocodesearch.length;i++){
      var code=ncltwocodesearch[i].code;
      ncltwo.push(code);
    }
    if(sqlbtabkey=="" && flzttabkey=="" && sqnftabkey==""){
      console.log("---------------------------------=========================================");
      for(var i=0;i<tmRegistNums.length;i++){
        var regNum=tmRegistNums[i];
        var data1={
          tmRegistNum:regNum
        };
        var tms =await this.GsbByTmSearchApi.imagesearch(data1);
        if(tms.status == 0 && tms.data.length>0){
          var tm=tms.data[0];
          var source={
            sbmc:tm.tm_name,//商标名称
            sbpy:tm.tm_name_py,//商标拼音
            sbyw:tm.tm_name_en,//商标英文
            gjfl:tm.ncl_one_codes,//国际分类
            gjflname:this.tm_gjfl[tm.ncl_one_codes],//国际分类名称
            sbzch:tm.tm_regist_num,//商标注册号
            sblx:this.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
            sbzt:this.tm_status[tm.status],//商标状态
            sqrq:this.convertDate(tm.apply_day),//申请日期
            csrq:this.convertDate(tm.first_notice_day),//初审日期
            zcrq:this.convertDate(tm.original_regist_notice_day),//注册日期
            csggym:tm.first_notice_page_num,//初审公告页码
            zcr:tm.applicant_cn,//申请人
            jzrq:this.convertDate(tm.tm_end_day) ,//截止日期
            csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
            zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
            csgg:tm.first_notice_issue,//初审公告（期号）
            zcgg:tm.regist_notice_issue,//注册公告
            zcggym:tm.regist_notice_page_num,//注册公告页码
            yzcr:tm.original_applicant_cn,//原申请人
            zcdz:tm.applicant_cn_addr,//申请地址
            zcren:tm.applicant_en,//申请人enlish
            zcdzen:tm.applicant_en_addr,//申请地址enlish
            dljg:tm.tm_agency,//代理机构
            zxzt:"",//最新状态
            spfwxm:"",
            lcxx:"",
            logo:tm.pic_url,//商标图样
          };
          sources.push(source);
        }
      }
      var data={
        tmRegistNumsAll:RegistNumsAll,
      };
      var tmsjuhe = await this.GsbByTmSearchApi.imagesearchjuheNcl(data);//获取ncl聚合结果
      var tmsjuhestatus = await this.GsbByTmSearchApi.imagesearchjuheStatus(data);//根据商标状态聚合
      var tmsjuheyear = await this.GsbByTmSearchApi.imagesearchjuheYear(data);//根据商标year聚合
      var that=this;
      if(tmsjuhe.status==0){
        tmsjuhe.buckets.sort(function(a,b){
          return a.key - b.key;
        });
        tmsjuhe.buckets.forEach(function(buck){
              var name = that.tm_gjfl[buck.key];
              var gjfl ={//国际分类
                "key":buck.key,
                "keyvalue":name,
                "keycount":buck.doc_count,
              };
              codes.push(gjfl);
        });
        result.code_counts=codes;
      }
      if(tmsjuhestatus.status==0){
        tmsjuhestatus.buckets.sort(function(a,b){
          return a.key - b.key;
        });
        tmsjuhestatus.buckets.forEach(function(buck){
          var name = that.tm_status[buck.key];
          var st={
            "key":buck.key,
            "keyvalue":name,
            "keycount":buck.doc_count,
          };
          flztstatus.push(st);
        });
        result.status_counts=flztstatus;
      }
      if(tmsjuheyear.status==0){
        tmsjuheyear.buckets.sort(function(a,b){
          return b.key - a.key;
        });
        tmsjuheyear.buckets.forEach(function(buck){
          var year={
            "key":buck.key,
            "keycount":buck.doc_count,
          };
          year_count.push(year);
        });
        result.year_counts=year_count;
      }
      result.rows=sources;
      result.count=tmRegistNumsAll.length;
      return System.getResult2(result,null);
    }else{
      console.log("0000000000000000000000000000000000000000000000000");
      var data={
        tmRegistNumsAll:RegistNumsAll,
        sqlbtabkey:sqlbtabkey,
        flzttabkey:flzttabkey,
        sqnftabkey:sqnftabkey,
        ncltwo:ncltwo,
        pagesize:ps,
        page:cp
      };
      var tms =await this.GsbByTmSearchApi.imagesearchbycode(data);
      // console.log(tms);
      var tmsjuhe = await this.GsbByTmSearchApi.imagesearchjuheNcl(data);//获取ncl聚合结果
      var tmsjuhestatus = await this.GsbByTmSearchApi.imagesearchjuheStatus(data);//根据商标状态聚合
      // console.log(tmsjuhestatus);
      var tmsjuheyear = await this.GsbByTmSearchApi.imagesearchjuheYear(data);//根据商标year聚合
      // console.log(tmzchjuheyear);
      var that=this;
      if(tms.status == 0 && tms.data.length>0){
        result.count=tms.total;
        tms.data.forEach(function(tm){
          var source={
               sbmc:tm.tm_name,//商标名称
               sbpy:tm.tm_name_py,//商标拼音
               sbyw:tm.tm_name_en,//商标英文
               gjfl:tm.ncl_one_codes,//国际分类
               gjflname:that.tm_gjfl[tm.ncl_one_codes],//国际分类名称
               sbzch:tm.tm_regist_num,//商标注册号
               sblx:that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
               sbzt:that.tm_status[tm.status],//商标状态
               sqrq:that.convertDate(tm.apply_day),//申请日期
               csrq:that.convertDate(tm.first_notice_day),//初审日期
               zcrq:that.convertDate(tm.original_regist_notice_day),//注册日期
               csggym:tm.first_notice_page_num,//初审公告页码
               zcr:tm.applicant_cn,//申请人
               jzrq:that.convertDate(tm.tm_end_day) ,//截止日期
               csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
               zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
               csgg:tm.first_notice_issue,//初审公告（期号）
               zcgg:tm.regist_notice_issue,//注册公告
               zcggym:tm.regist_notice_page_num,//注册公告页码
               yzcr:tm.original_applicant_cn,//原申请人
               zcdz:tm.applicant_cn_addr,//申请地址
               zcren:tm.applicant_en,//申请人enlish
               zcdzen:tm.applicant_en_addr,//申请地址enlish
               dljg:tm.tm_agency,//代理机构
               zxzt:"",//最新状态
               spfwxm:"",
               lcxx:"",
               logo:tm.pic_url,//商标图样
          };
          sources.push(source)
        });
          result.rows=sources;
      }
      if(tmsjuhe.status==0){
        tmsjuhe.buckets.sort(function(a,b){
          return a.key - b.key;
        });
        tmsjuhe.buckets.forEach(function(buck){
              var name = that.tm_gjfl[buck.key];
              var gjfl ={//国际分类
                "key":buck.key,
                "keyvalue":name,
                "keycount":buck.doc_count,
              };
              codes.push(gjfl);
        });
        result.code_counts=codes;
      }
      if(tmsjuhestatus.status==0){
        tmsjuhestatus.buckets.sort(function(a,b){
          return a.key - b.key;
        });
        tmsjuhestatus.buckets.forEach(function(buck){
          var name = that.tm_status[buck.key];
          var st={
            "key":buck.key,
            "keyvalue":name,
            "keycount":buck.doc_count,
          };
          flztstatus.push(st);
        });
        result.status_counts=flztstatus;
      }
      if(tmsjuheyear.status==0){
        tmsjuheyear.buckets.sort(function(a,b){
          return a.key - b.key;
        });
        tmsjuheyear.buckets.forEach(function(buck){
          var year={
            "key":buck.key,
            "keycount":buck.doc_count,
          };
          year_count.push(year);
        });
        result.year_counts=year_count;
      }
      console.log("--------------------------------------------------------------------");
      console.log(result);
      return System.getResult2(result,null);
    }
  }

  async tradeMarkDetail(query,obj){
    console.log(obj);
    var result={detaildata:[],nclexist:[],nclnotexist:[]};
    var sbzch=obj.sbzch;
    var gjfl=obj.gjfl;
    var sources=[];
    var data={
      sbzch:sbzch,
      gjfl:gjfl,
    };
    var data1={
      regNum:sbzch
    };
    var detailtms= await this.GsbByTmSearchApi.tradeMarkDetailapi(data);
    console.log("00000000000000000000000000000000000000000000000000000000");
    console.log(detailtms);
    var data2={
      reg_num:sbzch,
      nclone_code:gjfl
    }
    var qunzutms=await this.utilstmSve.getGroupNclInfo(data2);
    console.log("11111111111111111111111111111111111111111111111111111");
    console.log(qunzutms.data);
    if(qunzutms.status==0){
      result.nclexist=qunzutms.data.exist;
      result.nclnotexist=qunzutms.data.not_exist;
    }

    var tms =await this.GsbByTmSearchApi.getTmFlow(data1);
    var that=this;
    var lcxx="";
    if(tms.status == 0){
      tms.data.forEach(function(c){
        var date=that.convertDate(c.notice_data)
        lcxx=lcxx+date+" "+c.notice_type_name+"\n";
      });
    }
    if(detailtms.status == 0 && detailtms.data.length>0){
      var tm=detailtms.data[0];
      var source={
           sbmc:tm.tm_name,//商标名称
           sbpy:tm.tm_name_py,//商标拼音
           sbyw:tm.tm_name_en,//商标英文
           gjfl:tm.ncl_one_codes,//国际分类号
           gjflname:this.tm_gjfl[tm.ncl_one_codes],//国际分类名称
           sbzch:tm.tm_regist_num,//商标注册号
           sblx:this.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
           sbzt:this.tm_status[tm.status],//商标状态
           sqrq:this.convertDate(tm.apply_day),//申请日期
           csrq:this.convertDate(tm.first_notice_day),//初审日期
           zcrq:this.convertDate(tm.original_regist_notice_day),//注册日期
           csggym:tm.first_notice_page_num,//初审公告页码
           zcr:tm.applicant_cn,//申请人
           jzrq:this.convertDate(tm.tm_end_day) ,//截止日期
           csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
           zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
           csgg:tm.first_notice_issue,//初审公告（期号）
           zcgg:tm.regist_notice_issue,//注册公告
           zcggym:tm.regist_notice_page_num,//注册公告页码
           yzcr:tm.original_applicant_cn,//原申请人
           zcdz:tm.applicant_cn_addr,//申请地址
           zcren:tm.applicant_en,//申请人enlish
           zcdzen:tm.applicant_en_addr,//申请地址enlish
           dljg:tm.tm_agency,//代理机构
           lcxx:lcxx,
           logo:tm.pic_url,//商标图样
      };
      sources.push(source);
    }
    // else{
    //   var source={
    //        sbmc:"",//商标名称
    //        sbpy:"",//商标拼音
    //        sbyw:"",//商标英文
    //        gjfl:"",//国际分类
    //        sbzch:sbzch,//商标注册号
    //        gjflname:"",//国际分类名称
    //        sblx:"",//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
    //        sbzt:"",//商标状态
    //        sqrq:"",//申请日期
    //        csrq:"",//初审日期
    //        zcrq:"",//注册日期
    //        csggym:"",//初审公告页码
    //        zcr:"",//申请人
    //        jzrq:"",//截止日期
    //        csggqh:"",//初审公告（期号）
    //        zcggqh:"",//注册公告
    //        zcggym:"",//注册公告页码
    //        yzcr:"",//原申请人
    //        zcdz:"",//申请地址
    //        dljg:"",//代理机构
    //        zxzt:"",//最新状态
    //        spfwxm:"",
    //        lcxx:"",
    //        logo:"",//商标图样
    //   };
    //   sources.push(source);
    // }
    result.detaildata=sources;
    console.log(result);
    return System.getResult2(result,null);
  }

  async nclFuwuSearch(query,obj){
    var result ={rows:[],count:0};
    var nclfuwu = obj.nclfuwu;
    var pageSize=obj.pageSize;
    var currentPage=obj.currentPage;
    var sources=[];
    var data={
      nclfuwu:nclfuwu,
      pagesize:pageSize,
      page:currentPage
    }
    var fuwutms= await this.GsbByTmSearchApi.getNclByLikeName(data);
    var ncltwo={
      level:2
    }
    var tmpGetTwoNclList=await this.GsbByTmSearchApi.getNcl(ncltwo);
    var getTwoNclList=tmpGetTwoNclList.data;
    console.log("00000000000000000000000000000000000000000000000000000000");
    // console.log(fuwutms);
    // console.log(tmpGetTwoNclList);
    var that=this;
    if(fuwutms.status == 0){
      fuwutms.data.forEach(function(tm){
        // console.log(tm);
        var tmpTwoNclFind = getTwoNclList.find(f=>(f.code==tm.pid));
        // console.log(tmpTwoNclFind);
        // console.log("------------------------------------------");
          console.log(tm);
          console.log("+++++++++++++++++++++++++");
          console.log(tmpTwoNclFind);
          var source={
               nclthreecode:tm.code,//三类尼斯编号
               nclthreename:tm.name,//三类尼斯名字
               ncltwocode:tmpTwoNclFind.code,//二类尼斯编号
               ncltwoname:tmpTwoNclFind.name,//三类尼斯名字
               nclonecode:tmpTwoNclFind.pid,//国际分类
               nclonename:that.tm_gjfl[Number(tmpTwoNclFind.pid)],//国际分类名称
          };
          sources.push(source);
      });
      result.count=fuwutms.total;
      result.rows=sources;
    }
    console.log(result);
    return System.getResult2(result,null);
  }

  async gettwoNcl(query,obj){
    var result ={rows:[]};
    var pid = obj.code;
    console.log("-------------------------------");
    var sources=[];
    if(pid.length==1){
      pid="0"+pid;
    }
    var data={
      "pid":pid
    }
    var tmpGetTwoNclList=await this.GsbByTmSearchApi.gettwoNclList(data);
    var that=this;
    if(tmpGetTwoNclList.status == 0){
      tmpGetTwoNclList.data.forEach(function(tm){
          var source={
               code:tm.code,//2类尼斯编号
               name:tm.name//2类尼斯名字
          };
          sources.push(source);
      });
      result.rows=sources;
    }
    return System.getResult2(result,null);
  }

  async noticequery(query,obj){
    var result = {rows:[],count:""};
    var sources=[];
    var noticenumber=obj.noticenumber;
    var applynumber=obj.applynumber;
    var tmname=obj.tmname;
    var applier=obj.applier;
    var noticetype=obj.noticetype;
    var noticetypes=[];
    var pageSize=obj.pageSize;
    var currentPage=obj.currentPage;
    if(noticetype=="all"){
       noticetypes=["TMZCSQ","TMZCZC","TMQTZC"];
    }else{
       noticetypes=[noticetype];
    }
    var data ={
      noticenumber: noticenumber,
      applynumber:applynumber,
      tmname: tmname,
      applier: applier,
      noticetypes: noticetypes,
      pagesize:pageSize,
      page:currentPage
    }
    console.log("nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn");
    console.log(data);

    var notice=await this.GsbByTmSearchApi.noticeQueryAPi(data);
    console.log(notice);
    if(notice.status==0){
      result.count=notice.total;
      for (var i = 0; i < notice.data.length; i++) {
        var tm =notice.data[i];
        if(tm!=null){
          var source={
               sbmc:tm.tm_name,//商标名称
               sbzch:tm.tm_regist_num,//商标号
               zcr:tm.proposer,//申请人
               ggqh:tm.notice_issue+"("+this.convertDate(tm.notice_data)+")",//公告期号
               pagenumber:tm.page_no,//公告页码
               gglx:tm.notice_type_name,//公告类型
               linkurl:tm.link_url,   //连接地址
               logo:tm.pic_url //图片地址
          };
        }
        sources.push(source);
      }
    }
    result.rows=sources;
    return System.getResult2(result,null);
  }

  async getNclDetail(query,obj){
    var result={classification:"",construction:"",data:[]};
    var onecode=obj.number;
    var sources=[];
    if(onecode.length==1){
      onecode="0"+onecode;
    }
    var data={
      onecode:onecode
    }
    var tmpGetOneNcl=await this.GsbByTmSearchApi.getNclOne(data);
    console.log("nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn");
    console.log(tmpGetOneNcl);
    if(tmpGetOneNcl.status==0){
      var tm = tmpGetOneNcl.data[0];
      result.classification="第"+tm.code+"类-"+tm.name;
      result.construction=tm.description;
    }
    var data1={
      pid:onecode
    }
    var that=this;
    var tmpGetTwoNclList = await this.GsbByTmSearchApi.gettwoNclList(data1);
    console.log(tmpGetTwoNclList);
    if(tmpGetTwoNclList.status==0){
      for (var i = 0; i < tmpGetTwoNclList.data.length; i++) {
        var tm =tmpGetTwoNclList.data[i];
        if(tm!=null){
          var smallclassification=tm.code+" "+tm.name;
          console.log(tm);
          var piddata={
            twopid:tm.code,
          };
          var threeNcllist= await that.GsbByTmSearchApi.getthreeNclList(piddata);
          console.log("------------------------------------------------------");
          // console.log(threeNcllist);
          var content="";
          var xinzeng="";
          if(threeNcllist.status==0){
            threeNcllist.data.forEach(function(t){
              if(t.code){
                content=t.name+t.code+","+content;
              }else{
                xinzeng=t.name+","+xinzeng;
              }
            });
          }
          var source={
            smallclassification:smallclassification,
            content:content,
            xinzeng:xinzeng
          }
        }
        sources.push(source);
      }
    }
    console.log(sources);
    result.data=sources;
    return System.getResult2(result,null);
  }

  async aibynclone(obj,pobj){
    var tmName=pobj.tmName;
    var nclonecode=pobj.nclonecode;
    var result={};
    if( tmName == null || tmName == '' || tmName == 'undefined' )
    {
      result={code:-1,msg:"参数错误",data:null};
    }
    var rate = await this.GsbByTmSearchApi.tmncloneSearch(pobj);
    result={code:1,msg:"成功",data:rate};
    return System.getResult2(result,null);
  }

  async rediscache(query,obj){
    var result={redislist:[]};
    var openId=obj.user.openId
    var mark=obj.mark;
    var data={
      openId:openId,
      mark:mark
    };
    var rediscache =await this.testApi.opCache(data);
    console.log(rediscache);
    if(rediscache.code==1){
      result.redislist=rediscache.data.reverse();;
    }
    return System.getResult2(result,null);
  }

  async noticesearch(query,obj){
    var result={sbmc:"",linkurl:""};
    var sbzch=obj.sbzch;
    var csggqh=obj.csggqh;

    var data={
      sbzch:sbzch,
      csggqh:csggqh
    };
    var notice=await this.GsbByTmSearchApi.noticeSearch(data);
    console.log(notice);
    if(notice.status==0){
      if(notice.data.length>0){
        result.sbmc=notice.data[0].tm_name;
        result.linkurl=notice.data[0].link_url;
      }
    }
    return System.getResult2(result,null);
  }
  async noticezcggsearch(query,obj){
    var result={sbmc:"",linkurl:""};
    var sbzch=obj.sbzch;
    var zcggqh=obj.zcggqh;

    var data={
      sbzch:sbzch,
      zcggqh:zcggqh
    };
    var notice=await this.GsbByTmSearchApi.noticezcgg(data);
    console.log(notice);
    if(notice.status==0){
      if(notice.data.length>0){
        result.sbmc=notice.data[0].tm_name;
        result.linkurl=notice.data[0].link_url;
      }
    }
    return System.getResult2(result,null);
  }
}
module.exports=bytmqueryCtl;
