var System=require("../../system");
var settings=require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
const logCtl=System.getObject("web.oplogCtl");
class businesschanceCtl extends CtlBase{
  constructor(){
    super(CtlBase.getServiceName(businesschanceCtl));
    this.shopSve=System.getObject("service.shopSve");
    this.channelSve=System.getObject("service.channelSve");
    this.servicesitemSve=System.getObject("service.servicesitemSve");
  }
  //needh5获取相应产品信息列表-----暂时不想要
  async getServiceItemList(pobj,obj,req){
    if(obj.itemType=="recommand"){
      var pobj={
        channel:"wssyh5",
        recommend:1,
        shopOnlyCode:"odnZ4twQmg_AmwrHv6JPIEZqamj8"
      }
    }else{
      var pobj={
        channel:"wssyh5",
        itemtype:obj.itemType,
        shopOnlyCode:"odnZ4twQmg_AmwrHv6JPIEZqamj8"
      }
    }
    var service=await this.shopSve.getServiceItemListForNeedh5(pobj);
    return service;
  }
  //neeh5提交需求
  async submitneed(pobj,obj,req){
    if(obj.publisherName==""||obj.publisherName==null||obj.publisherName=="undefined"){
      return {code:-100,msg:"请填写您的姓名"};
    }
    if(obj.publisherMobile==""||obj.publisherMobile==null||obj.publisherMobile=="undefined"){
      return {code:-100,msg:"请填写您的电话"};
    }
    if(obj.notes!=""&&obj.notes!=null&&obj.notes!="undefined"&&obj.notes.length>255){
      return {code:-100,msg:"备注字数超出限制，请重新填写"};
    }
    if(obj.serviceItem_code==""||obj.serviceItem_code==null||obj.serviceItem_code=="undefined"){
      return {code:-110,msg:"serviceItem_code参数传递错误"};
    }
    var tChannelCode=obj.channelCode==""||obj.channelCode==null||obj.channelCode=="undefined"?"":obj.channelCode;
    if(tChannelCode==""){
      return {code:-111,msg:"channelCode参数传递错误"};
    }
    var channelItem=await this.channelSve.getChannelItem(tChannelCode);
    if(channelItem==""||channelItem==null){
      return {code:-112,msg:"channelCode参数传递错误"};
    }
    var serviceItem=await this.servicesitemSve.findOneByCode(obj.serviceItem_code);
    if(serviceItem==""||serviceItem==null){
      return {code:-113,msg:"serviceItem_code参数传递错误"};
    }
    var pobj={
      publisherName:obj.publisherName,
      publisherMobile:obj.publisherMobile,
      serviceItem_code:obj.serviceItem_code,
      channelCode:tChannelCode,
      chanceStatus:"1"
    };
    //验证小程序求购需求
    var tPublisherOnlyCode=obj.publisherOnlyCode==""||obj.publisherOnlyCode==null||obj.publisherOnlyCode=="undefined"?"":obj.publisherOnlyCode;
    var tShopOnlyCode=obj.shopOnlyCode==""||obj.shopOnlyCode==null||obj.shopOnlyCode=="undefined"?"":obj.shopOnlyCode;
    if(tShopOnlyCode!=""){
      pobj.shopOnlyCode=tShopOnlyCode;
    }
    var result=await this.service.findchance(pobj);
    if(result!=""&&result!=null){
      return {code:"0",msg:"您已经发布需求，请不要重复提交"};
    }
    try{
      //channelItem===
      var reqParams={
        notes:obj.notes,
        publisherName:obj.publisherName,
        publisherMobile:obj.publisherMobile,
        channelCode:tChannelCode,
        serviceItem_code:obj.serviceItem_code,
        serviceItem_name:serviceItem.name,
        publisherOnlyCode:tPublisherOnlyCode,
        shopOnlyCode:tShopOnlyCode,
        chanceStatus:"1",
        chanceType:serviceItem.itemType,
        channelProfitRatio:channelItem.profitType==1?(channelItem.everySingleProfit||0):0,//渠道分成比率（如：总额100，字段值30，则渠道的利润为30/100，剩下的则为平台利润）
        channelProfit:channelItem.profitType==2?(channelItem.everySingleProfit||0):0,//渠道利润
        profitType:channelItem.profitType//渠道利润类型:1: "比例分成", 2: "每单分成"
      };
      //新增的省份和城市
      var tCity=obj.city||"";
      var tProvince=obj.province||"";
      if(tCity && tProvince){
        reqParams.city=tCity;
        reqParams.province=tProvince;
      }
      var chance = await this.service.create(reqParams);
      this.smsClient=System.getObject("util.smsClient");
      this.smsClient.sendMsg("13381139519","亲爱的知产合伙人，你的客户于"+(new Date()).Format("yyyy-MM-dd")+"发布了新的需求，亲，赶紧去自己店铺去查看“我的商机”吧！");
      return {code:"1",msg:"发布成功"};
    }catch(e){
      console.log(e);
      //日志记录
      logCtl.error({
         optitle:"渠道neeh5提交需求异常",
         op:"/controller/impl/businesschanceCtl/submitneed",
         content:"请求参数："+JSON.stringify(obj)+"，error："+e.stack,
         clientIp:""
       });
      return {code:"-1",msg:"操作失败，请稍后重试"};
    }
  }
  async publishChance(obj,req){
    try{
      var user=req.session.user;
      var app = req.session.app;
      var type=obj.type;
      var reqParams={
          app_id:app.id,
          publisherId:user.id,
          chanceStatus:"1",
          chanceType:type
      };
      var ch=await this.service.findOne(reqParams);
      if(ch!=null){
        return {code:"2",data:reqParams};
      }
      var chanceObj={
        app_id:app.id,
        publisherId:user.id,
        publisherName:user.nickName,
        publisherMobile:obj.mobile,
        publisherOnlyCode:user.onlyCode,
        chanceType:type,
        chanceStatus:"1",
        platformChanceType:"common",
      };
      var chance = this.service.create(chanceObj);
      return {code:"1",data:chance};
    }catch(e){
      return {code:"-1"};
    }
  }
  async findAllChances(obj,req){
    var user=req.session.user;
    var queryObj={
      publisherId:user.id
    };
    return this.service.findAllChances(queryObj);

  }
}
module.exports=businesschanceCtl;
