var system=require("../../system")
var settings=require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
const logCtl=system.getObject("web.oplogCtl");
class BusinessallotCtl extends CtlBase{
   constructor() {
     super(CtlBase.getServiceName(BusinessallotCtl));
   }
   async receipt(queryobj,qobj,req){
     let id = qobj.id;
     let userId = req.session.user.id;

     if(!id) {
       return system.getErrResult2("请选择订单");
     }
     if(!userId) {
       return system.getErrResult2("请重新登录");
     }
     let rs = await this.service.receipt(id, userId);
     if(rs == -1) {
       return system.getErrResult2("当前任务不属于您");
     }
     return system.getResult2(rs);
   }

   // async findAndCountAll(queryobj,qobj,req){
   //   //日志记录
   //   logCtl.info({
   //      optitle:"获取派单列表:findAndCountAll",
   //      op:"controller/impl/businessallotCtl/findAndCountAll",
   //      content:"参数："+JSON.stringify(qobj),
   //      clientIp:""
   //    });
   //   var tlist=await super.findAndCountAll(queryobj,qobj,req);
   //   //日志记录
   //   logCtl.info({
   //      optitle:"获取派单列表:findAndCountAll==结果",
   //      op:"controller/impl/businessallotCtl/findAndCountAll",
   //      content:"tlist结果："+JSON.stringify(tlist),
   //      clientIp:""
   //    });
   //   return tlist;
   //
   // }

   async giveup(queryobj,qobj,req){
     let id = qobj.id;
     let userId = req.session.user.id;
     let reason = qobj.reason;

     if(!id) {
       return system.getErrResult2("请选择订单");
     }
     if(!userId) {
       return system.getErrResult2("请重新登录");
     }
     let rs = await this.service.giveup(id, userId, reason);
     if(rs == -1) {
       return system.getErrResult2("当前任务不属于您");
     }
     return system.getResult2(rs);
   }

   async success(queryobj,qobj,req){
     let id = qobj.id;
     let userId = req.session.user.id;
     let reason = qobj.reason;
     let money = qobj.money;

     if(!id) {
       return system.getErrResult2("请选择订单");
     }
     if(!money) {
       return system.getErrResult2("成单金额必须输入");
     }
     var tMoney=parseFloat(money);
     if(isNaN(tMoney) ){
       return system.getErrResult2("成单金额必须为数字");
     }
     if(!userId) {
       return system.getErrResult2("请重新登录");
     }
     let rs = await this.service.success(id, userId, tMoney, reason,"add");
     if(rs == -1) {
       return system.getErrResult2("当前任务不属于您");
     }
     return system.getResult2(rs);
   }
   async putsuccess(queryobj,qobj,req){
     let id = qobj.id;
     let userId = req.session.user.id;
     let reason = qobj.reason;
     let money = qobj.money;

     if(!id) {
       return system.getErrResult2("请选择订单");
     }
     if(!money) {
       return system.getErrResult2("成单金额必须输入");
     }
     var tMoney=parseFloat(money);
     if(isNaN(tMoney) ){
       return system.getErrResult2("成单金额必须为数字");
     }
     if(!userId) {
       return system.getErrResult2("请重新登录");
     }
     let rs = await this.service.success(id, userId, tMoney, reason,"put");
     if(rs == -1) {
       return system.getErrResult2("当前任务不属于您");
     }
     return system.getResult2(rs);
   }
   async failue(queryobj,qobj,req){
     let id = qobj.id;
     let userId = req.session.user.id;
     let reason = qobj.reason;

     if(!id) {
       return system.getErrResult2("请选择订单");
     }
     if(!userId) {
       return system.getErrResult2("请重新登录");
     }
     let rs = await this.service.failue(id, userId, reason);
     if(rs == -1) {
       return system.getErrResult2("当前任务不属于您");
     }
     return system.getResult2(rs);
   }
}
module.exports=BusinessallotCtl;
