var system=require("../../system")
const http=require("http")
const querystring = require('querystring');
var settings=require("../../../config/settings");
const CtlBase = require("../ctl.base");
class AttachmentCtl extends CtlBase{
   constructor(){
     super(CtlBase.getServiceName(AttachmentCtl));
     this.restS=system.getObject("util.restClient");
     this.appDao=system.getObject("db.appDao");
     this.userDao=system.getObject("db.userDao");
     this.accountDao=system.getObject("db.accountDao");
     this.productDao=system.getObject("db.productDao");
     this.accountSve=system.getObject("service.accountSve");
   }
   async create(qobj,pobj,req){
     var productId=pobj.productId;
     var key=pobj.key;
     var originUrl=pobj.originUrl;
     var name=pobj.name;
     var user=req.session.user;
     var accountId=user.account_id;
     var product=await this.productDao.model.findOne({where:{id:productId}});
     var app=await this.appDao.model.findOne({where:{id:user.app_id}});
      var usr =await this.userDao.model.findOne({where:{id:user.id}});
     var account=await this.accountDao.model.findOne({where:{id:accountId}});
     var attachmentObj={
       key:key,
       name:name,
       originUrl:originUrl,
       transformUrl:"",
       userId:user.id,
       userName:user.nickName,
       appid:user.app_id,
       appName:app.name,
       user:usr,
       account:account,
       productId:productId
     };
     //this.model.querry("")
     var att =await this.service.create(attachmentObj);
     await this.accountSve.delAccountBalance(user.account_id,app.id);
     var accountBalance=await this.accountSve.getAccountBalance(user.account_id,user.app_id);
     att.dataValues["accountBalance"]=accountBalance;
     att.dataValues["price"]=product.price;
     return att;
   }
}
module.exports=AttachmentCtl;
