var system=require("../../system")
var settings=require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
class AdvicelettercaseCtl extends CtlBase{
   constructor(){
     super(CtlBase.getServiceName(AdvicelettercaseCtl));
     this.apifq=system.getObject('api.fqtmsearch');
     this.imghandleApi=system.getObject("api.imghandle");
   }

   async nclonebyscope(pobj,obj,req){
     var companyName=pobj.companyName;
     var tmName=pobj.tmName;
     var s={appKey:'wx76a324c5d201d1a4',companyName:companyName,tmName:tmName};
     var ncls=await this.apifq.tjdlSearch(s);
     return system.getResult2(ncls,null);
   }

   async save(pobj,obj,req){
     var user=obj.session.user;
     var form=JSON.parse(pobj.alc);
     form.user_id=user.id;
     form.app_id=user.app_id;
     form.onlyCode=user.onlyCode;
     form.nclOnes= JSON.stringify(form.nclOnes)
     var s=await this.service.create(form);
   }

   async findbyid(pobj,obj,req){
     var id=pobj.id;
     var s=await this.service.findById(id);
     return system.getResult2(s,null);
   }

   async createalc(o,req){
     var app=req.session.app;
     var obj={
       "appKey":app.appid,
       "url":o.url
     };
     var id=o.id;
     var result=await this.imghandleApi.makeDeleForTM(obj);
     var alcinfo=await this.service.findById(id);
     alcinfo=alcinfo.dataValues;
     if(alcinfo.id!=null){
       alcinfo.aclPDF=result.data.url;
       var rd=await this.service.update(alcinfo);
     }
     return result;
   }

}
module.exports=AdvicelettercaseCtl;
